#ifndef MARS_MCalibrationRelTimeCam
#define MARS_MCalibrationRelTimeCam

#ifndef MARS_MCalibrationCam
#include "MCalibrationCam.h"
#endif

#ifndef ROOT_TArrayI
#include "TArrayI.h"
#endif


class MCalibrationRelTimeCam : public MCalibrationCam
{
private:
  
  TArrayI fNumUncalibrated;
  TArrayI fNumUnreliable;

public:

  MCalibrationRelTimeCam(const char *name=NULL, const char *title=NULL);
  ~MCalibrationRelTimeCam() {}

  Int_t  GetNumUncalibrated        ( const Int_t aidx) const   { return fNumUncalibrated[aidx]; }
  Int_t  GetNumUnreliable          ( const Int_t aidx) const   { return fNumUnreliable  [aidx]; }

  // Prints
  void Print(Option_t *o="") const;
  
  // Others
  Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void DrawPixelContent(Int_t num) const;    

  void   SetNumUncalibrated    ( const Int_t i, const Int_t aidx)   { fNumUncalibrated[aidx] = i; }
  void   SetNumUnreliable      ( const Int_t i, const Int_t aidx)   { fNumUnreliable  [aidx] = i; }
  
  ClassDef(MCalibrationRelTimeCam, 1)	// Container Rel. Arrival Time Calibration Results Camera
};

#endif
