/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug 05/2004 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */
//////////////////////////////////////////////////////////////////////////////
//
//  MHCalibrationTestTimePix
//
//  Histogram class for the charge calibration. 
//  Stores and fits the charges and stores the location of the maximum FADC 
//  slice. TestTimes are taken from MExtractedSignalPix.
//
//////////////////////////////////////////////////////////////////////////////
#include "MHCalibrationTestTimePix.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MHCalibrationTestTimePix);

using namespace std;

const Int_t   MHCalibrationTestTimePix::fgChargeNbins     = 600;
const Axis_t  MHCalibrationTestTimePix::fgChargeFirst     = -0.5;
const Axis_t  MHCalibrationTestTimePix::fgChargeLast      = 29.5;
// --------------------------------------------------------------------------
//
// Default Constructor. 
//
// Sets: 
// - the default number for fNbins        (fgChargeNbins)
// - the default number for fFirst        (fgChargeFirst)
// - the default number for fLast         (fgChargeLast)
//
// - the default name of the  fHGausHist ("HCalibrationTestTime")
// - the default title of the fHGausHist ("Distribution of calibrated FADC slices Pixel ")
// - the default x-axis title for fHGausHist ("Sum FADC Slices")
// - the default y-axis title for fHGausHist ("Nr. of events")
//
// Calls:
// - Clear();
//
MHCalibrationTestTimePix::MHCalibrationTestTimePix(const char *name, const char *title)
{ 
  
  fName  = name  ? name  : "MHCalibrationTestTimePix";
  fTitle = title ? title : "Statistics of the calibrated FADC sums of calibration events";

  SetNbins ( fgChargeNbins );
  SetFirst ( fgChargeFirst );
  SetLast  ( fgChargeLast  );

  fHGausHist.SetName("HCalibrationTestTime");
  fHGausHist.SetTitle("Distribution of calibrated Arrival Times Pixel");  
  fHGausHist.SetXTitle("Arrival Time [FADC units]");
  fHGausHist.SetYTitle("Nr. of events");

}


// --------------------------------------------------------------------------
//
// Empty function to overload MHGausEvents::Reset()
//
void MHCalibrationTestTimePix::Reset()
{
}

