#ifndef MARS_MMinuitInterface
#define MARS_MMinuitInterface

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class TArrayD;
class TArrayI;

class MMinuitInterface : public MParContainer
{
private:
    UInt_t   fNpar;
    Double_t fMin,   fEdm,   fErrdef;
    Int_t    fNpari, fNparx, fIstat;
    Int_t    fErrMinimize;

public:
    MMinuitInterface(const char *name=NULL, const char *title=NULL);

    Bool_t CallMinuit(
                      void (*fcn)(Int_t &, Double_t *, Double_t &, Double_t *, Int_t),
                      const TString *name, const TArrayD &vinit, const TArrayD &step,
                      const TArrayD &limlo, const TArrayD &limup, const TArrayI &fix,
                      TObject *fObjectFit, const TString &method, Bool_t nulloutput);

    ClassDef(MMinuitInterface, 0) // Class for interfacing with Minuit
};

#endif






























