#ifndef MARS_MHCalibrationTestCam
#define MARS_MHCalibrationTestCam

#ifndef MARS_MHCalibrationCam
#include "MHCalibrationCam.h"
#endif

class MGeomCam;
class MHCalibrationTestCam : public MHCalibrationCam
{

private:

  Bool_t ReInitHists(MParList *pList);
  Bool_t FillHists(const MParContainer *par, const Stat_t w=1);
  Bool_t FinalizeHists();
  void    FinalizeBadPixels();
  
public:

  MHCalibrationTestCam(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationTestCam() {}

  Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void DrawPixelContent(Int_t idx) const;

  void CalcAverageSigma();
  
  ClassDef(MHCalibrationTestCam, 0)	// Histogram class for Relative Time Camera Calibration
};

#endif

