#ifndef MARS_MFEnergySlope
#define MARS_MFEnergySlope
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MFEnergySlope                                                           //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MParList;
class MMcEvt;
class MMcCorsikaRunHeader;

class MFEnergySlope : public MFilter
{
private:
    Int_t fNumSelectedEvts; // counter for number of selected events

    MMcEvt *fEvt;           // Events used to determin energy slope

    Bool_t fResult;         // Result returned by IsExpressionTrue
    Float_t fNewSlope;      // New slope set by user

    Float_t fMcSlope;       // Original energy slope from MC data
    Float_t fMcMinEnergy;   // Starting energy of MC data
    Float_t fMcMaxEnergy;   // Ending energy of MC data

    Float_t fN0;            // Normalization factor

    Int_t PreProcess(MParList *pList);
    Int_t Process();

public:
    MFEnergySlope(const char *name=NULL, const char *title=NULL);

    Bool_t IsExpressionTrue() const { return fResult; }

    // Slope is used with positive values in the code 
    void SetNewSlope(Float_t f) {fNewSlope = TMath::Abs(f);}
    void SetMcSlope(Float_t f) {fMcSlope = TMath::Abs(f);}

    void SetMcMinEnergy(Float_t f) {fMcMinEnergy = f;}
    void SetMcMaxEnergy(Float_t f) {fMcMaxEnergy = f;}

    ClassDef(MFEnergySlope, 0) // A Filter to select events with a given energy slope
};

#endif






