#ifndef MARS_MExtractFixedWindowPeakSearch
#define MARS_MExtractFixedWindowPeakSearch

#ifndef MARS_MExtractor
#include "MExtractor.h"
#endif

class MExtractFixedWindowPeakSearch : public MExtractor
{
private:

  static const Byte_t fgHiGainFirst;
  static const Byte_t fgHiGainLast;
  static const Byte_t fgLoGainFirst;
  static const Byte_t fgLoGainLast;
  static const Byte_t fgHiGainWindowSize;     // Default for fWindowSizeHiGain (now set to: 6)
  static const Byte_t fgLoGainWindowSize;     // Default for fWindowSizeLoGain (now set to: 6)
  static const Byte_t fgPeakSearchWindowSize; // Default for fPeakSearchWindowSize (now set to: 4)
  static const Byte_t fgOffsetFromPeak;       // Default for fOffsetFromPeak   (now set to: 2)
  
  Byte_t  fWindowSizeHiGain;     // Number of Hi Gain slices in window
  Byte_t  fWindowSizeLoGain;     // Number of Lo Gain slices in window
  Byte_t  fPeakSearchWindowSize; // Size of FADC window in the search for the highest peak of all pixels.
  Byte_t  fOffsetFromPeak;       // Number of slices to start extraction from global peak

  void   FindSignalHiGain(Byte_t *ptr, Byte_t *logain, Int_t &sum, Byte_t &sat) const;
  void   FindSignalLoGain(Byte_t *ptr, Int_t &sum, Byte_t &sat) const;  

  void   FindPeak(Byte_t *ptr, Byte_t window, Byte_t &startslice, Int_t &signal, Int_t &sat) const;

  Bool_t  ReInit(MParList *pList);
  Int_t  Process();
  
public:

    MExtractFixedWindowPeakSearch(const char *name=NULL, const char *title=NULL);

    void SetRange(Byte_t hifirst=0, Byte_t hilast=0, Byte_t lofirst=0, Byte_t lolast=0);    
    void SetWindows(Byte_t windowh=fgHiGainWindowSize, Byte_t windowl=fgLoGainWindowSize, 
		    Byte_t peaksearchwindow=fgPeakSearchWindowSize);
    void SetOffsetFromPeak(Byte_t offset=fgOffsetFromPeak)    {  fOffsetFromPeak = offset; }
    
    ClassDef(MExtractFixedWindowPeakSearch, 0) // Signal Extractor for fixed size trigger-corrected extraction window 
};

#endif
