#ifndef MARS_MExtractedSignalBlindPixel
#define MARS_MExtractedSignalBlindPixel

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#include <TArrayI.h>

class MExtractedSignalBlindPixel : public MParContainer
{
private:

  UInt_t fExtractedSignal;    // mean value of the extracted signal

  Byte_t fFirst;
  Byte_t fNumFADCSamples;
  Byte_t fNumSaturated;

  Float_t fPed;
  Float_t fPedErr;
  Float_t fPedRms;
  Float_t fPedRmsErr;

  Int_t fBlindPixelIdx;

public:

  MExtractedSignalBlindPixel(const char* name=NULL, const char* title=NULL);

  void Clear(Option_t *o="");
  void Print(Option_t *o="") const;
  
  // Setter
  void SetExtractedSignal(const UInt_t sig    )    { fExtractedSignal = sig;     }
  void SetNumSaturated(   const Byte_t numsat )    { fNumSaturated    = numsat;  }
  void SetUsedFADCSlices( const Byte_t first, const Byte_t num);
  void SetNumFADCSamples( const Byte_t num    )    { fNumFADCSamples  = num;     }    

  void SetPed(      const Float_t f )     { fPed       = f; }
  void SetPedErr(   const Float_t f )     { fPedErr    = f; }
  void SetPedRms(   const Float_t f )     { fPedRms    = f; }
  void SetPedRmsErr(const Float_t f )     { fPedRmsErr = f; }

  void SetBlindPixelIdx( const Int_t i)   { fBlindPixelIdx = i; }

    // Getter
  UInt_t GetExtractedSignal()    const { return fExtractedSignal; }
  Byte_t GetNumFADCSamples()     const { return fNumFADCSamples;  }
  Int_t  GetBlindPixelIdx()      const { return fBlindPixelIdx; }  

  Bool_t IsValid() const;   

  Float_t GetPed()       const { return fPed;       }
  Float_t GetPedErr()    const { return fPedErr;    }
  Float_t GetPedRms()    const { return fPedRms;    }
  Float_t GetPedRmsErr() const { return fPedRmsErr; }

  ClassDef(MExtractedSignalBlindPixel, 0)	// Storage Container for Extracted Signal of the blind pixel
};

#endif




