#ifndef MARS_MExtractBlindPixel
#define MARS_MExtractBlindPixel

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MExtractBlindPixel                                                      //
//                                                                         //
// Integrates the time slices of the all pixels of a calibration event     //
// and substract the pedestal value                                        //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MExtractor
#include "MExtractor.h"
#endif

class MExtractedSignalBlindPixel;
class MExtractBlindPixel : public MExtractor
{
private:

  static const Int_t  fgBlindPixelIdx;
  static const Int_t  fgNSBFilterLimit;  
  static const Byte_t fgHiGainFirst;     // First FADC slice Hi-Gain (currently set to: 0) 
  static const Byte_t fgHiGainLast;      // Last FADC slice Hi-Gain (currently set to: 11) 
  static const Byte_t fgLoGainFirst;     // First FADC slice Lo-Gain (currently set to: 0) 
  static const Byte_t fgLoGainLast;      // Last FADC slice Lo-Gain (currently set to:  2) 

  MExtractedSignalBlindPixel  *fBlindPixel;   // Extracted signal of the Blind Pixel

  Int_t   fBlindPixelIdx;
  Int_t   fNSBFilterLimit;  

  void FindSignalHiGain(Byte_t *firstused, Byte_t *lowgain, Int_t &sum, Byte_t &sat) const;
  void FindSignalFilter(Byte_t *ptr, Int_t &sum, Byte_t &sat) const;
  
  Int_t  PreProcess(MParList *pList);
  Int_t  Process();

public:

  MExtractBlindPixel(const char *name=NULL, const char *title=NULL);

  // Setters
  void SetRange(Byte_t hifirst=0, Byte_t hilast=0, Byte_t lofirst=0, Byte_t lolast=0);
  void SetBlindPixelIdx(  const  Int_t idx=fgBlindPixelIdx  ) { fBlindPixelIdx   = idx; }
  void SetNSBFilterLimit(  const  Int_t lim=fgNSBFilterLimit ) { fNSBFilterLimit     = lim; }    

  ClassDef(MExtractBlindPixel, 0) // Signal Extractor for the Blind Pixel
};

#endif

