/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Javier Lpez, 04/2004 <mailto:jlopez@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */


Bool_t HandleInput()
{
    TTimer timer("gSystem->ProcessEvents();", 50, kFALSE);
    while (1)
    {
        //
        // While reading the input process gui events asynchronously
        //
        timer.TurnOn();
        TString input = Getline("Type 'q' to exit, <return> to go on: ");
        timer.TurnOff();

        if (input=="q\n")
            return kFALSE;

        if (input=="\n")
            return kTRUE;
    };

    return kFALSE;
}


void hvnotnominal(const TString filename="20040319_20821_D_Mrk421_S.root", const TString directory="/nfs/magic/CaCodata/2004_03_19/")
{

  //
  // Create a empty Parameter List and an empty Task List
  // The tasklist is identified in the eventloop by its name
  //
  MParList  plist;
  
  MTaskList tlist;
  plist.AddToList(&tlist);


  MGeomCamMagic geomcam;
  MBadPixelsCam badcam;
  MCameraHV     hvcam;

  // this line is needed because the CC rep rootified file don't have run header,
  // then the MGeomApply can not initialitaze the containers with the number of 
  // pixels because this is done in the reinit().
  badcam.InitSize(geomcam.GetNumPixels());
  
  plist.AddToList(&geomcam);
  plist.AddToList(&badcam);
  plist.AddToList(&hvcam);

  //
  // Now setup the tasks and tasklist:
  // ---------------------------------
  //

  // Reads the trees of the root file and the analysed branches
  MReadReports read;
  read.AddTree("Camera"); 
  read.AddFile(directory+filename);     // after the reading of the trees!!!
  read.AddToBranchList("MReportCamera.*");

  MGeomApply geomapl;
  MFHVNotNominal fHVNominal;
  TString hvnominal = "/nfs/ifae.es/user/j/jlopez/Mars/ConfigFiles/HVSettings_FF35q.conf";
  fHVNominal.SetHVNominalValues(hvnominal);
  //  fHVNominal.SetMaxNumPixelsDeviated(10);
  MContinue cont_hv(&fHVNominal);

  tlist.AddToList(&read);
  tlist.AddToList(&geomapl);
  tlist.AddToList(&cont_hv);

  //
  // Create and setup the eventloop
  //
  MEvtLoop evtloop;
  evtloop.SetParList(&plist);
     
  //
  // Execute your analysis
  //

  if (!evtloop.Eventloop())
    return;

  tlist.PrintStatistics();

}


