#ifndef MARS_MGMap
#define MARS_MGMap

#ifndef ROOT_GuiTypes
#include <GuiTypes.h> // Drawable_t
#endif
#ifndef ROOT_TExMap
#include <TExMap.h>
#endif

class TString;
class TGToolTip;

class MGMap : public TExMap
{
private:
    //    TGToolTip *fToolTip;   //! The tooltip currently displayed

    enum {
        kIsOwner    = BIT(14),
        // kNoToolTips = BIT(15), // suppress tooltips
    };

    //    void ShowToolTip(Int_t px, Int_t py, const char *txt);

public:
    MGMap(Int_t mapSize = 100);
    ~MGMap();

    void     SetOwner(Bool_t o=kTRUE) { o ? SetBit(kIsOwner) : ResetBit(kIsOwner); }
    void     Add(TObject *k, TString *v=0);
    void     Delete(Option_t *opt = "");

    //    void   SetNoToolTips(Bool_t b=kTRUE) { b ? SetBit(kNoToolTips) : ResetBit(kNoToolTips); } // *TOGGLE* *GETTER=HasNoToolTips
    //    Bool_t HasNoToolTips() const         { return TestBit(kNoToolTips); }

    void     Paint(Option_t *o="");
    void     Paint(unsigned char *buf, int w, int h, Float_t scale);
    //void     Paint(Drawable_t id, Float_t scale);

    Int_t    Color(int col);

    void     DrawLine(TObject *o, unsigned char *buf, int w, int h, Double_t scale);
    void     DrawMarker(TObject *o, unsigned char *buf, int w, int h, Double_t scale);

    //void     EventInfo(Int_t event, Int_t px, Int_t py, TObject *selected);
    TObject *PickObject(Int_t px, Int_t py, TString &str) const;
    char    *GetObjectInfo(Int_t px, Int_t py) const;
    Int_t    DistancetoPrimitive(Int_t px, Int_t py);

    ClassDef(MGMap, 1) // Special TExMap supporting enhanced drawing and bitmap drawing
};

#endif
