/////////////////////////////////////////////////////////////////////////////
//
//       This macro makes the alpha-plot for one of the positions of the 
//     False Source Method:
//
//                 Ester Aliu   <aliu@ifae.es>
//                 Oscar Blanch <blanch@ifae.es>
//                 Javier Rico  <jrico@ifae.es>
////////////////////////////////////////////////////////////////////////////

void signalPoint(Int_t i=0, Int_t j=0, TString fname="hillasCrab/falseSourceCrab20040215.root")
{  
  // constants
  const Int_t nbins = 18;
  
  // general settings
  gROOT->Reset();
  gStyle->SetCanvasColor(0);
  gStyle->SetCanvasBorderMode(0);
  gStyle->SetPadBorderMode(0);
  gStyle->SetFrameBorderMode(0);
  gStyle->SetOptTitle(0);
  gStyle->SetTitleOffset(1.7,"y");
  gStyle->SetPadLeftMargin(0.15);
  gStyle->SetOptStat(111110);
  gStyle->SetStatColor(0);
  gStyle->SetStatBorderSize(1);
  gStyle->SetStatW(0.2);
  gStyle->SetStatH(0.1);
  gStyle->SetStatX(0.9);
  gStyle->SetStatY(0.9);
  
  
  //  open file and access to the histograms
  TFile *f = new TFile(fname);
  
  Char_t name[20]; 
  Char_t title[50]; 
  
  sprintf(name,"hOnAlpha[%d][%d]", i, j);
  sprintf(title,"Alpha-Plot(On data) (%d ,%d)", i, j);
  TH1F* onhisto = (TH1F*)gDirectory->Get(name);   
  
  sprintf(name,"hOffAlpha[%d][%d]", i, j);
  sprintf(title,"Alpha-Plot(Off data) (%d ,%d)", i, j);
  TH1F* offhisto = (TH1F*)gDirectory->Get(name);   

  TPostScript myps("signalpoint.ps",111);
  myps.Range(15,15);
  TCanvas *c1 = new TCanvas("c1","c1",800,600);
  c1->cd(1);

  // line/normalization
  const Int_t inibin = 20./90.*nbins+1;
  Float_t level=0;
  Float_t leveloff=0;
  Float_t levelofferror=0;
  for(Int_t ibin = inibin; ibin<=nbins;ibin++)
    {
      level+=onhisto->GetBinContent(ibin);
      leveloff+=offhisto->GetBinContent(ibin);
    }
  level/=(nbins-inibin+1);
  leveloff/=(nbins-inibin+1);
  
  // normalize on/off
  offhisto->Sumw2(); // needed to compute correct errors after normalization
  const Float_t norm = level/leveloff;
  cout << "Normalizing by factor " << norm <<endl;
  offhisto->Scale(norm);    
  
  // significance:
  Float_t sig=0,bg=0,esig=0,ebg=0;
  Float_t significance=0;
  const Int_t signbins = inibin-1;
  for(Int_t ibin = 1; ibin<=signbins;ibin++)
    {
      //	Float_t sigma = (onhisto->GetBinContent(ibin)-level)/onhisto->GetBinError(ibin);
      //	significance+=sigma*sigma;
      sig  += onhisto->GetBinContent(ibin);
      esig += onhisto->GetBinError(ibin)*onhisto->GetBinError(ibin);
      bg   += offhisto->GetBinContent(ibin);
      ebg  += offhisto->GetBinError(ibin)*offhisto->GetBinError(ibin);
    }
  Float_t error= TMath::Sqrt(esig+ebg);
  significance = (sig-bg)/error;
  
  cout << "Significance: " << significance << endl;
  
  // plot
  onhisto->SetXTitle("alpha (deg)");
  onhisto->SetYTitle("Entries");
  onhisto->SetMarkerColor(4);
  onhisto->SetMarkerStyle(20);
  onhisto->SetMarkerSize(.7);
  onhisto->SetLineColor(4);
  onhisto->SetMaximum(onhisto->GetBinContent(nbins)*1.5);
  
  offhisto->SetFillColor(2);
  offhisto->SetMaximum(offhisto->GetBinContent(nbins)*1.5);
  offhisto->SetXTitle("alpha (deg)");
  offhisto->SetYTitle("Entries");
  
  offhisto->Draw("HIST");
  offhisto->Draw("ESAME");
  onhisto->Draw("ESAMES");
  //    onhisto->Draw("E");
  
  // move stat box to make them all visible
  gPad->Update();
  TPaveStats* offpavstat = (TPaveStats*) offhisto->GetListOfFunctions()->FindObject("stats");
  if(offpavstat)
    {
      Float_t shiftx = offpavstat->GetX2NDC()-offpavstat->GetX1NDC();
      offpavstat->SetX1NDC(offpavstat->GetX1NDC()-shiftx);
      offpavstat->SetX2NDC(offpavstat->GetX2NDC()-shiftx);
    }
  
  // draw line
  TLine* line = new TLine(0.,level,90.,level);
  line->SetLineColor(2);
  line->SetLineStyle(2);
  //    line->Draw();
  
  gPad->Modified();
  gPad->Update();
  
  myps.Close();
}


