#ifndef MARS_MTriggerIPR
#define MARS_MTriggerIPR

#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif
#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif 

#ifndef ROOT_TArrayL
#include <TArrayL.h>
#endif

class MTriggerIPR : public MParContainer, public MCamEvent
{
    friend class MReportCamera;
private:
    Byte_t  fStatus;        // Monitor of the L2T status

    TArrayL fIPR;            // Array of the measured IPR

public:
    MTriggerIPR() : fIPR(397)
    {
        fName  = "MTriggerIPR";
        fTitle = "Container for the Individual Pixel Rate (IPR)";
    }

    Float_t GetMean() const { return fIPR.GetSum()/fIPR.GetSize(); }

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const
    {
        val = fIPR[idx];
        return val>0;
    }

    Double_t operator[](const UInt_t idx) { return fIPR[idx]; }

    void DrawPixelContent(Int_t num) const
    {
    }

    ClassDef(MTriggerIPR, 1) // Container for the Individual Pixel Rate (IPR)
};

#endif
