/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 11/2003 <mailto:tbretz@astro.uni-wuerzburg.de>
!              Antonio Stamerra, 05/2004 <mailto:antonio.stamerra@pi.infn.it>
! 
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//
//  MReportTrigger
//
// This is the class interpreting and storing the TRIGGER-REPORT information.
//  Updated to add IPR; data format follows TDAS 00-07
//
//////////////////////////////////////////////////////////////////////////////
#include "MReportTrigger.h"

#include "MLogManip.h"
#include "MTriggerIPR.h"

ClassImp(MReportTrigger);

using namespace std;

// --------------------------------------------------------------------------
//
// Default construtor. Initialize identifier to "TRIGGER-REPORT"
//
MReportTrigger::MReportTrigger() : MReport("TRIGGER-REPORT"), fPrescalerRates(19)
{
    fName  = "MReportTrigger";
    fTitle = "Class for TRIGGER-REPORT information";
}

// --------------------------------------------------------------------------
//
// FindCreate the following objects:
//  - MTriggerIPR
//  - MTriggerCell
//  - MTriggerBit
//  - MTriggerPrescFact
//
Bool_t MReportTrigger::SetupReading(MParList &plist)
{
  fPixel = (MTriggerIPR*)plist.FindCreateObj("MTriggerIPR");
  if (!fPixel)
    return kFALSE;

  fCell = (MTriggerCell*)plist.FindCreateObj("MTriggerCell");
  if (!fCell)
    return kFALSE;

  fBit = (MTriggerBit*)plist.FindCreateObj("MTriggerBit");
  if (!fBit)
    return kFALSE;

  fPrescFactor = (MTriggerPrescFact*)plist.FindCreateObj("MTriggerPrescFact");
  if (!fPrescFactor)
    return kFALSE;
  
  return MReport::SetupReading(plist);
}

// --------------------------------------------------------------------------
//
// Interprete the Cell rates part of the report
//
Int_t MReportTrigger::InterpreteCell(TString &str)
{

  return kTRUE;
}

// --------------------------------------------------------------------------
//
// Interprete the Bit rates part of the report
//
Int_t MReportTrigger::InterpreteBit(TString &str)
{

  return kTRUE;
}

// --------------------------------------------------------------------------
//
// Interprete the IPR part of the report
//
Int_t MReportTrigger::InterpreteIPR(TString &str)
{

  return kTRUE;
}

// --------------------------------------------------------------------------
//
// Interprete the Prescaling factors part of the report
//
Int_t MReportTrigger::InterpretePrescFact(TString &str)
{

  return kTRUE;
}

// --------------------------------------------------------------------------
//
// Interprete the body of the TRIGGER-REPORT string
//  Read comments for details
//
Int_t MReportTrigger::InterpreteBody(TString &str)
{
    str = str.Strip(TString::kLeading);
 
    // Extract trigger table name
    const Int_t ws = str.First(' ');
 
   if (ws<=0)
    {
        *fLog << warn << "WARNING - Cannot determine name of trigger table." << endl;
        return kCONTINUE;
    }

    TString tablename = str(0, ws);
    str.Remove(0, ws);

    // Read the cell rates (32 fields)
    if (!InterpreteCell(str))
      return kCONTINUE;


    /*
    const char *pos = str.Data();

    const Char_t pro[4] = {pos[0],pos[1],pos[2],pos[3]};
    *fLog << warn << pro[0] <<" " <<pro[1] <<" " <<pro[2] <<" " <<pro[3]<<endl;
    
    Int_t len, n;
    Float_t dummy;
    */

    // Read L1 and L2 table name (2 fields)

    // Read prescaling factors  (2x8 fields)
    if (!InterpretePrescFact(str))
      return kCONTINUE;
    
    // Read livetime and deadtime (5x4 fields)

    // Read L2 outout bit rates
    if (!InterpreteBit(str))
      return kCONTINUE;

    // Read global rates (before and after prescaling)

    // Read 18 dummy fields

    // Read IPR
    if (!InterpreteBit(str))
      return kCONTINUE;

    /*
    for (int i=0; i < 19; i++)
    {
        n = sscanf(pos, " %f %n", &fPrescalerRates[i], &len);
        if (n!=1)
        {
            *fLog << warn << "WARNING - Cell Scaler Value #" << i << " missing." << endl;
            return kCONTINUE;
        }
        pos += len;
    }
    n = sscanf(pos, " %f %f %n", &fL2BeforePrescaler, &fL2AfterPrescaler, &len);
    if (n!=2)
    {
        *fLog << warn << "WARNING - Couldn't read Trigger rates." << endl;
        return kFALSE;
    }
    pos += len;
    */
			   /*

    // Read Individual pixel rates
    pos = str.Data();
    end = str.Data() + 344;

    Int_t i=0;
    while (pos < end)
    {
        const Char_t hex[4] = { pos[0], pos[1], pos[2], 0 };
        n = sscanf(hex, "%hx", &fRates->fRates[i++]);
	pos++;
        if (n!=1)
        {
            *fLog << warn << "WARNING - Rate #" << i << " missing." << endl;
            return kFALSE;
        }
    }

			   */
    str.Remove(0, pos-str.Data());
    str.Strip(TString::kBoth);

    return str==(TString)"OVER" ? kTRUE : kCONTINUE;
}
