/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 1/2004 <mailto:tbretz@astro.uni-wuerzburg.de>
!              Markus Gaug, 02/2004 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */
/////////////////////////////////////////////////////////////////////////////
//
//  MGCamDisplays
//
//  Graphical interfaces to display the camera with fits and projections
//
/////////////////////////////////////////////////////////////////////////////
#include "MGCamDisplays.h"

#include <TStyle.h>
#include <TCanvas.h>

#include "MH.h"
#include "MHCamera.h"
#include "MGeomCam.h"
#include "TVirtualPad.h"

#include "MLog.h"
#include "MLogManip.h"

#include "MStatusDisplay.h"

ClassImp(MGCamDisplays);

using namespace std;

// --------------------------------------------------------------------------
//
// Default constructor. 
//
MGCamDisplays::MGCamDisplays() 
{
}

// --------------------------------------------------------------------------
//
// Draw the MHCamera into the MStatusDisplay: 
// 
// 1) Draw it as histogram (MHCamera::DrawCopy("hist")
// 2) Draw it as a camera, with MHCamera::SetPrettyPalette() set. 
// 3) If "rad" is not zero, draw its values vs. the radius from the camera center. 
//    (DrawRadialProfile())
// 4) Depending on the variable "fit", draw the values projection on the y-axis
//    (DrawProjection()):
//    0: don't draw
//    1: Draw fit to Single Gauss (for distributions flat-fielded over the whole camera)
//    2: Draw and fit to Double Gauss (for distributions different for inner and outer pixels)
//    3: Draw and fit to Triple Gauss (for distributions with inner, outer pixels and outliers)
//    4: Draw and fit to Polynomial grade 0: (for the probability distributions)
//    >4: Draw and don;t fit.
//
void MGCamDisplays::CamDraw(TCanvas &c, const Int_t x, const Int_t y, const MHCamera &cam1, 
                            const Int_t fit, const Int_t rad, TObject *notify)
{

    c.cd(x);
    gPad->SetBorderMode(0);
    gPad->SetTicks();
    MHCamera *obj1=(MHCamera*)cam1.DrawCopy("hist");
    obj1->SetDirectory(NULL);

    if (notify)
      obj1->AddNotify(notify);

    c.cd(x+y);
    gPad->SetBorderMode(0);
    obj1->SetPrettyPalette();
    obj1->Draw();

    if (rad)
      {
        c.cd(x+2*y);
        gPad->SetBorderMode(0);
        gPad->SetTicks();
        obj1->DrawRadialProfile();
      }
    

    if (!fit)
        return;

    c.cd(rad ? x+3*y : x+2*y);
    gPad->SetBorderMode(0);
    gPad->SetTicks();
    obj1->DrawProjection(fit);
}


