#ifndef MARS_MHillasDisplay
#define MARS_MHillasDisplay

#ifndef MARS_MDisplay
#include "MDisplay.h"
#endif

class MCerPhotEvt;
class MSrcPosCam;
class MGeomCam;
class MHillas;
class MIslands;
class MNewImagePar;

class MHillasDisplay : public MDisplay
{
 private:
  MHillas*      fHillas;    // pointer to container with the hillas parameters
  MNewImagePar* fNewImage;  // pointer to container with the new image parameters
  MSrcPosCam*   fSrcPos;    // pointer to the source position in camera
  MIslands*     fIslands;   // pointer to the islands

  virtual Int_t PreProcess(MParList *plist);
  virtual Int_t Process();

 public:
  MHillasDisplay(MCerPhotEvt* event, MGeomCam* geom, Int_t type=0,
		 const char* name=NULL, const char* title=NULL);

  virtual ~MHillasDisplay(){};

  void SetHillas(MHillas* hillas)    {fHillas=hillas;}
  void SetSrcPos(MSrcPosCam* srcpos) {fSrcPos=srcpos;}
  void SetIslands(MIslands* islands) {fIslands=islands;}

  virtual void Paint(Option_t* option);

  ClassDef(MHillasDisplay, 0) // task to display cleaned events with hillas parameters
};

#endif

