/////////////////////////////////////////////////////////////////////////////
//
//           _____Macro for checking the hillas parameters_____
//
//                       Ester Aliu  <aliu@ifae.es>
////////////////////////////////////////////////////////////////////////////
void hillasONOFF(
TString onname,
TString offname,
TString psname)
{    
    // general settings
    gROOT->Reset();
    gStyle->SetCanvasColor(0);
    gStyle->SetCanvasBorderMode(0);
    gStyle->SetPadBorderMode(0);
    gStyle->SetFrameBorderMode(0);
    gStyle->SetOptStat(kFALSE);
    // gStyle->SetTitleSize(0);
    gStyle->SetStatColor(0);
    gStyle->SetStatBorderSize(1);
    gStyle->SetStatW(0.2);
    gStyle->SetStatH(0.1);
    gStyle->SetStatX(0.9);
    gStyle->SetStatY(0.9);
 
       
    // define file, tree, canvas
    TFile *fdata = new TFile(onname);
    TTree *t = Parameters;                                                     
    
    // define file, tree, canvas
    TFile *fdata2 = new TFile(offname);
    TTree *t2 = Parameters;  
   
    TString title;

    TH1F* hLength; 
    TH1F* hWidth; 
    TH1F* hDist;
    TH1F* hConc;
    TH1F* hConc1;
    TH1F* hConc6;
    TH1F* hAlpha; 
    TH1F* hSize; 

    TH2F *hXY;

    // define aliases
    t->SetAlias("length","MHillas.fLength*0.6/189");
    t->SetAlias("width","MHillas.fWidth*0.6/189");
    t->SetAlias("dist","MHillasSrc.fDist*0.6/189");
    t->SetAlias("conc","MNewImagePar.fConc");
    t->SetAlias("conc1","MNewImagePar.fConc1");
    t->SetAlias("conc6","MConcentration.fConc[6]");
    t->SetAlias("size","MHillas.fSize");
    t->SetAlias("alpha","abs(MHillasSrc.fAlpha)");
    t->SetAlias("meanx","MHillas.fMeanX");
    t->SetAlias("meany","MHillas.fMeanY");

    // define aliases
    t2->SetAlias("length","MHillas.fLength*0.6/189");
    t2->SetAlias("width","MHillas.fWidth*0.6/189");
    t2->SetAlias("dist","MHillasSrc.fDist*0.6/189");
    t2->SetAlias("conc","MNewImagePar.fConc");
    t2->SetAlias("conc1","MNewImagePar.fConc1");
    t2->SetAlias("conc6","MConcentration.fConc[6]");
    t2->SetAlias("size","MHillas.fSize");
    t2->SetAlias("alpha","abs(MHillasSrc.fAlpha)");
    t2->SetAlias("meanx","MHillas.fMeanX");
    t2->SetAlias("meany","MHillas.fMeanY");

      
    // define  cuts
    const char* cut1 = "size>500";
    const char* cut2 = "size>1000";
    const char* cut3 = "size>2000";
    const char* cut4 = "size>5000";
    const char* cut5 = "size>10000";

    const char* cutDist = "MHillasSrc.fDist*0.6/189.>0.2 && MHillasSrc.fDist*0.6/189.<0.8";


    /*****************************************************************
    ****                         PLOTS                            ****
    *****************************************************************/
    
    Int_t nbin;
    Float_t min;
    Float_t max;


    TString openpsname;
    openpsname = psname + "(";

    TString closepsname;
    closepsname = psname  + ")";


    //////////////////////////////////////////////////////////////
    //                    Cuts in Size
    //////////////////////////////////////////////////////////////
    TCanvas *c1 = new TCanvas("c1","c1",500,800);
    c1->Divide(2,3);
    /////////////////////////////////////////////////////////////////

    char* var="length>>hLength";    

    nbin = 40; min = 0.; max = 1.;

    c1->cd(1);
    c1->GetPad(1)->SetGrid();    
    title = "length " ;
    hLength = new TH1F("hLength",title,nbin, min, max);
    t->Draw(var, "","goff");  
    hLength->SetXTitle("degrees");
    hLength->SetNormFactor(1.);
    hLength->Draw("Ehist");
    c1->GetPad(1)->Update();    
    
    c1->cd(2);
    c1->GetPad(2)->SetGrid();    
    title = "length ";  
    title = title + cut1;
    hLength = new TH1F("hLength",title, nbin, min, max);
    t->Draw(var,cut1,"goff");
    hLength->SetXTitle("degrees");
    hLength->SetNormFactor(1.);
    hLength->Draw("Ehist");    
    c1->GetPad(2)->Update();
  
    c1->cd(3);
    c1->GetPad(3)->SetGrid();    
    title = "length ";  
    title = title + cut2;
    hLength = new TH1F("hLength",title,nbin, min, max);
    t->Draw(var,cut2,"goff");
    hLength->SetXTitle("degrees");
    hLength->SetNormFactor(1.);
    hLength->Draw("Ehist");
    c1->GetPad(3)->Update();
  
    c1->cd(4);
    c1->GetPad(4)->SetGrid();    
    title = "length ";  
    title = title + cut3;
    hLength = new TH1F("hLength",title,nbin, min, max);
    t->Draw(var,cut3, "goff");
    hLength->SetXTitle("degrees");
    hLength->SetNormFactor(1.);
    hLength->Draw("Ehist");
    c1->GetPad(4)->Update();
        
    c1->cd(5);
    c1->GetPad(5)->SetGrid();    
    title = "length ";  
    title = title + cut4;
    hLength = new TH1F("hLength",title,nbin, min, max);
    t->Draw(var,cut4, "goff");
    hLength->SetXTitle("degrees");
    hLength->SetNormFactor(1.);
    hLength->Draw("Ehist");
    c1->GetPad(5)->Update();
        
    c1->cd(6);
    c1->GetPad(6)->SetGrid();    
    title = "length ";  
    title = title + cut5;
    hLength = new TH1F("hLength",title,nbin, min, max);
    t->Draw(var,cut5, "goff");
    hLength->SetXTitle("degrees");
    hLength->SetNormFactor(1.);
    hLength->Draw("Ehist");
    c1->GetPad(6)->Update();
   
    //off data

    c1->cd(1);
    title = "length " ;
    hLength = new TH1F("hLength",title,nbin, min, max);
    t2->Draw(var, "","goff");  
    hLength->SetXTitle("degrees");
    //hLength->SetLineStyle(2);
    hLength->SetMarkerStyle(20);
    hLength->SetMarkerSize(0.4);
    hLength->SetNormFactor(1);
    hLength->Draw("samePE");
    c1->GetPad(1)->Modified();    
    c1->GetPad(1)->Update();    
    
    c1->cd(2);
    title = "length ";  
    title = title + cut1;
    hLength = new TH1F("hLength",title, nbin, min, max);
    t2->Draw(var,cut1,"goff");
    hLength->SetXTitle("degrees");
    //hLength->SetLineStyle(2);
    hLength->SetMarkerSize(0.4);
    hLength->SetMarkerStyle(20);
    hLength->SetNormFactor(1);
    hLength->Draw("samePE");    
    c1->GetPad(2)->Modified();    
    c1->GetPad(2)->Update();
  
    c1->cd(3);
    title = "length ";  
    title = title + cut2;
    hLength = new TH1F("hLength",title,nbin, min, max);
    t2->Draw(var,cut2,"goff");
    //hLength->SetXTitle("degrees");
    hLength->SetMarkerSize(0.4);
    hLength->SetMarkerStyle(20);
    //hLength->SetLineStyle(2);
    hLength->SetNormFactor(1);
    hLength->Draw("samePE");
    c1->GetPad(3)->Modified();    
    c1->GetPad(3)->Update();
  
    c1->cd(4);
    title = "length ";  
    title = title + cut3;
    hLength = new TH1F("hLength",title,nbin, min, max);
    t2->Draw(var,cut3, "goff");
    hLength->SetXTitle("degrees");
    //    hLength->SetLineStyle(2);
    hLength->SetMarkerStyle(20);
    hLength->SetMarkerSize(0.4);
    hLength->SetNormFactor(1);
    hLength->Draw("samePE");
    c1->GetPad(4)->Modified();    
    c1->GetPad(4)->Update();
        
    c1->cd(5);
    title = "length ";  
    title = title + cut4;
    hLength = new TH1F("hLength",title,nbin, min, max);
    t2->Draw(var,cut4, "goff");
    hLength->SetXTitle("degrees");
    //hLength->SetLineStyle(2);
    hLength->SetMarkerStyle(20);
    hLength->SetMarkerSize(0.4);
    hLength->SetNormFactor(1);
    hLength->Draw("samePE");
    c1->GetPad(5)->Modified();    
    c1->GetPad(5)->Update();
        
    c1->cd(6);
    title = "length ";  
    title = title + cut5;
    hLength = new TH1F("hLength",title,nbin, min, max);
    t2->Draw(var,cut5, "goff");
    hLength->SetXTitle("degrees");
    // hLength->SetLineStyle(2);
    hLength->SetMarkerStyle(20);
    hLength->SetMarkerSize(0.4);
    hLength->SetNormFactor(1);
    hLength->Draw("samePE");
    c1->GetPad(6)->Modified();    
    c1->GetPad(6)->Update();
    
    c1->Print(openpsname); 

    /////////////////////////////////////////////////////////////////
    char* var="width>>hWidth";

    nbin = 40; min = 0.; max = 0.8;

    c1->cd(1);
    title = "width ";  
    hWidth = new TH1F("hWidth",title,nbin, min, max);
    t->Draw(var, "", "goff");
    hWidth->SetXTitle("degrees");
    hWidth->SetNormFactor(1.);
    hWidth->Draw("Ehist");
    c1->GetPad(1)->Update();    

    c1->cd(2);
    title = "width ";  
    title = title + cut1;
    hWidth = new TH1F("hWidth",title,nbin, min, max);
    t->Draw(var,cut1, "goff");
    hWidth->SetXTitle("degrees");
    hWidth->SetNormFactor(1.);
    hWidth->Draw("Ehist");    
    c1->GetPad(2)->Update();
    
    c1->cd(3);
    title = "width ";  
    title = title + cut2;
    hWidth = new TH1F("hWidth",title,nbin, min, max);
    t->Draw(var,cut2, "goff");
    hWidth->SetXTitle("degrees");
    hWidth->SetNormFactor(1.);
    hWidth->Draw("Ehist");
    c1->GetPad(3)->Update();
    
    c1->cd(4);
    title = "width ";  
    title = title + cut3;
    hWidth = new TH1F("hWidth",title,nbin, min, max);
    t->Draw(var,cut3, "goff");
    hWidth->SetXTitle("degrees");
    hWidth->SetNormFactor(1.);
    hWidth->Draw("Ehist");
    c1->GetPad(4)->Update();
    
    c1->cd(5);
    title = "width ";  
    title = title + cut4;
    hWidth = new TH1F("hWidth",title,nbin, min, max);
    t->Draw(var,cut4, "goff");
    hWidth->SetXTitle("degrees");
    hWidth->SetNormFactor(1.);
    hWidth->Draw("Ehist");
    c1->GetPad(5)->Update();
    
    c1->cd(6);
    title = "width ";  
    title = title + cut5;
    hWidth = new TH1F("hWidth",title,nbin, min, max);
    t->Draw(var,cut5, "goff");
    hWidth->SetXTitle("degrees");
    hWidth->SetNormFactor(1.);
    hWidth->Draw("Ehist");
    c1->GetPad(6)->Update();

    // offdata
   
    c1->cd(1);
    title = "width ";  
    hWidth = new TH1F("hWidth",title,nbin, min, max);
    t2->Draw(var, "", "goff");
    hWidth->SetXTitle("degrees");
    //hWidth->SetLineStyle(2);
    hWidth->SetMarkerStyle(20);
    hWidth->SetMarkerSize(0.4);
    hWidth->SetNormFactor(1);
    hWidth->Draw("samePE");
    c1->GetPad(1)->Modified();    
    c1->GetPad(1)->Update();    

    c1->cd(2);
    title = "width ";  
    title = title + cut1;
    hWidth = new TH1F("hWidth",title,nbin, min, max);
    t2->Draw(var,cut1, "goff");
    hWidth->SetXTitle("degrees");
    //hWidth->SetLineStyle(2);
    hWidth->SetMarkerStyle(20);
    hWidth->SetMarkerSize(0.4);
    hWidth->SetNormFactor(1);
    hWidth->Draw("samePE");    
    c1->GetPad(2)->Modified();    
    c1->GetPad(2)->Update();
    
    c1->cd(3);
    title = "width ";  
    title = title + cut2;
    hWidth = new TH1F("hWidth",title,nbin, min, max);
    t2->Draw(var,cut2, "goff");
    hWidth->SetXTitle("degrees");
    //hWidth->SetLineStyle(2);
    hWidth->SetMarkerStyle(20);
    hWidth->SetMarkerSize(0.4);
    hWidth->SetNormFactor(1);
    hWidth->Draw("samePE");
    c1->GetPad(3)->Modified();    
    c1->GetPad(3)->Update();
    
    c1->cd(4);
    title = "width ";  
    title = title + cut3;
    hWidth = new TH1F("hWidth",title,nbin, min, max);
    t2->Draw(var,cut3, "goff");
    hWidth->SetXTitle("degrees");
    //hWidth->SetLineStyle(2);
    hWidth->SetMarkerStyle(20);
    hWidth->SetMarkerSize(0.4);
    hWidth->SetNormFactor(1);
    hWidth->Draw("samePE");
    c1->GetPad(4)->Modified();    
    c1->GetPad(4)->Update();
    
    c1->cd(5);
    title = "width ";  
    title = title + cut4;
    hWidth = new TH1F("hWidth",title,nbin, min, max);
    t2->Draw(var,cut4, "goff");
    hWidth->SetXTitle("degrees");
    // hWidth->SetLineStyle(2);
    hWidth->SetMarkerStyle(20);
    hWidth->SetMarkerSize(0.4);
    hWidth->SetNormFactor(1);
    hWidth->Draw("samePE");
    c1->GetPad(5)->Modified();    
    c1->GetPad(5)->Update();
    
    c1->cd(6);
    title = "width ";  
    title = title + cut5;
    hWidth = new TH1F("hWidth",title,nbin, min, max);
    t2->Draw(var,cut5, "goff");
    hWidth->SetXTitle("degrees");
    //hWidth->SetLineStyle(2);
    hWidth->SetMarkerStyle(20);
    hWidth->SetMarkerSize(0.4);
    hWidth->SetNormFactor(1);
    hWidth->Draw("samePE");
    c1->GetPad(6)->Modified();    
    c1->GetPad(6)->Update();

   
    c1->Print(psname); 
 
    /////////////////////////////////////////////////////////////////

    char* var="dist>>hDist";
      
    nbin = 40; min = 0.; max = 1.6;

    c1->cd(1);
    title = "dist ";  
    hDist = new TH1F("hDist",title,nbin, min, max);   
    t->Draw(var, "", "goff");
    hDist->SetXTitle("degrees");
    hDist->SetNormFactor(1.);
    hDist->Draw("Ehist");
    c1->GetPad(1)->Update();    

    c1->cd(2);
    title = "dist ";  
    title = title + cut1;
    hDist = new TH1F("hDist",title,nbin, min, max);
    t->Draw(var,cut1, "goff");
    hDist->SetXTitle("degrees");
    hDist->SetNormFactor(1.);
    hDist->Draw("Ehist");    
    c1->GetPad(2)->Update();
    
    c1->cd(3);
    title = "dist ";  
    title = title + cut2;
    hDist = new TH1F("hDist",title,nbin, min, max);
    t->Draw(var,cut2, "goff");
    hDist->SetXTitle("degrees");
    hDist->SetNormFactor(1.);
    hDist->Draw("Ehist");
    c1->GetPad(3)->Update();
    
    c1->cd(4);
    title = "dist ";  
    title = title + cut3;
    hDist = new TH1F("hDist",title,nbin, min, max);
    t->Draw(var,cut3, "goff");
    hDist->SetXTitle("degrees");
    hDist->SetNormFactor(1.);
    hDist->Draw("Ehist");
    c1->GetPad(4)->Update();
    
    c1->cd(5);
    title = "dist ";  
    title = title + cut4;
    hDist = new TH1F("hDist",title,nbin, min, max);
    t->Draw(var,cut4, "goff");
    hDist->SetXTitle("degrees");
    hDist->SetNormFactor(1.);
    hDist->Draw("Ehist");
    c1->GetPad(5)->Update();
    
    c1->cd(6);
    title = "dist ";  
    title = title + cut5;
    hDist = new TH1F("hDist",title,nbin, min, max);
    t->Draw(var,cut5,"goff");
    hDist->SetXTitle("degrees");
    hDist->SetNormFactor(1.);
    hDist->Draw("Ehist");
    c1->GetPad(6)->Update();

    //offdata

    c1->cd(1);
    title = "dist ";  
    hDist = new TH1F("hDist",title,nbin, min, max);   
    t2->Draw(var, "", "goff");
    hDist->SetXTitle("degrees");
    //hDist->SetLineStyle(2);
    hDist->SetMarkerStyle(20);
    hDist->SetMarkerSize(0.4);
    hDist->SetNormFactor(1);
    hDist->Draw("samePE");
    c1->GetPad(1)->Modified();    
    c1->GetPad(1)->Update();    

    c1->cd(2);
    title = "dist ";  
    title = title + cut1;
    hDist = new TH1F("hDist",title,nbin, min, max);
    t2->Draw(var,cut1, "goff");
    hDist->SetXTitle("degrees");
    //hDist->SetLineStyle(2);
    hDist->SetMarkerStyle(20);
    hDist->SetMarkerSize(0.4);
    hDist->SetNormFactor(1);
    hDist->Draw("samePE");    
    c1->GetPad(2)->Modified();    
    c1->GetPad(2)->Update();
    
    c1->cd(3);
    title = "dist ";  
    title = title + cut2;
    hDist = new TH1F("hDist",title,nbin, min, max);
    t2->Draw(var,cut2, "goff");
    hDist->SetXTitle("degrees");
    //hDist->SetLineStyle(2);
    hDist->SetMarkerStyle(20);
    hDist->SetMarkerSize(0.4);   
    hDist->SetNormFactor(1);
    hDist->Draw("samePE");
    c1->GetPad(3)->Modified();    
    c1->GetPad(3)->Update();
    
    c1->cd(4);
    title = "dist ";  
    title = title + cut3;
    hDist = new TH1F("hDist",title,nbin, min, max);
    t2->Draw(var,cut3, "goff");
    hDist->SetXTitle("degrees");
    //hDist->SetLineStyle(2);
    hDist->SetMarkerStyle(20);
    hDist->SetMarkerSize(0.4);
    hDist->SetNormFactor(1);
    hDist->Draw("samePE");
    c1->GetPad(4)->Modified();    
    c1->GetPad(4)->Update();
    
    c1->cd(5);
    title = "dist ";  
    title = title + cut4;
    hDist = new TH1F("hDist",title,nbin, min, max);
    t2->Draw(var,cut4, "goff");
    hDist->SetXTitle("degrees");
    //hDist->SetLineStyle(2);
    hDist->SetMarkerStyle(20);
    hDist->SetMarkerSize(0.4);
    hDist->SetNormFactor(1);
    hDist->Draw("samePE");
    c1->GetPad(5)->Modified();    
    c1->GetPad(5)->Update();
    
    c1->cd(6);
    title = "dist ";  
    title = title + cut5;
    hDist = new TH1F("hDist",title,nbin, min, max);
    t2->Draw(var,cut5,"goff");
    hDist->SetXTitle("degrees");
    //hDist->SetLineStyle(2);
    hDist->SetMarkerStyle(20);
    hDist->SetMarkerSize(0.4);
    hDist->SetNormFactor(1);
    hDist->Draw("samePE");
    c1->GetPad(6)->Modified();    
    c1->GetPad(6)->Update();

    c1->Print(psname); 

    /////////////////////////////////////////////////////////////////
    char* var="conc>>hConc";

    nbin = 40; min = 0.; max = 1.;

    c1->cd(1);
    title = "conc ";  
    hConc = new TH1F("hConc",title,nbin, min, max);
    t->Draw(var,"","goff");
    hConc->SetNormFactor(1.);
    hConc->Draw("Ehist");
    c1->GetPad(1)->Update();    

    c1->cd(2);
    title = "conc ";  
    title = title + cut1;
    hConc = new TH1F("hConc",title,nbin, min, max);
    t->Draw(var,cut1,"goff");    
    hConc->SetNormFactor(1.);
    hConc->Draw("Ehist");
    c1->GetPad(2)->Update();
    
    c1->cd(3);
    title = "conc ";  
    title = title + cut2;
    hConc = new TH1F("hConc",title,nbin, min, max);
    t->Draw(var,cut2,"goff");
    hConc->SetNormFactor(1.);
    hConc->Draw("Ehist");
    c1->GetPad(3)->Update();
    
    c1->cd(4);
    title = "conc ";  
    title = title + cut3;
    hConc = new TH1F("hConc",title,nbin, min, max);
    t->Draw(var,cut3,"goff");
    hConc->SetNormFactor(1.);
    hConc->Draw("Ehist");
    c1->GetPad(4)->Update();
    
    c1->cd(5);
    title = "conc ";  
    title = title + cut4;
    hConc = new TH1F("hConc",title,nbin, min, max);
    t->Draw(var,cut4,"goff");
    hConc->SetNormFactor(1.);
    hConc->Draw("Ehist");
    c1->GetPad(5)->Update();
    
    c1->cd(6);
    title = "conc ";  
    title = title + cut5;
    hConc = new TH1F("hConc",title,nbin, min, max);
    t->Draw(var,cut5,"goff");
    hConc->SetNormFactor(1.);
    hConc->Draw("Ehist");
    c1->GetPad(6)->Update();
  
    //offdata 

    c1->cd(1);
    title = "conc ";  
    hConc = new TH1F("hConc",title,nbin, min, max);
    t2->Draw(var, "","goff");
    hConc->SetNormFactor(1.);
    //hConc->SetLineStyle(2);
    hConc->SetMarkerStyle(20);
    hConc->SetMarkerSize(0.4);
    hConc->Draw("samePE");
    c1->GetPad(1)->Modified();    
    c1->GetPad(1)->Update();    

    c1->cd(2);
    title = "conc ";  
    title = title + cut1;
    hConc = new TH1F("hConc",title,nbin, min, max);
    t2->Draw(var,cut1,"goff");
    hConc->SetNormFactor(1.);
    hConc->SetMarkerStyle(20);
    hConc->SetMarkerSize(0.4);
    // hConc->SetLineStyle(2);
    hConc->Draw("samePE");
    c1->GetPad(2)->Modified();        
    c1->GetPad(2)->Update();
    
    c1->cd(3);
    title = "conc ";  
    title = title + cut2;
    hConc = new TH1F("hConc",title,nbin, min, max);
    t2->Draw(var,cut2,"goff");
    hConc->SetNormFactor(1.);
    hConc->SetMarkerStyle(20);
    hConc->SetMarkerSize(0.4);
    //hConc->SetLineStyle(2);
    hConc->Draw("samePE");
    c1->GetPad(3)->Modified();    
    c1->GetPad(3)->Update();
    
    c1->cd(4);
    title = "conc ";  
    title = title + cut3;
    hConc = new TH1F("hConc",title,nbin, min, max);
    t2->Draw(var,cut3,"goff");
    hConc->SetNormFactor(1.);
    hConc->SetMarkerStyle(20);
    hConc->SetMarkerSize(0.4);
    //hConc->SetLineStyle(2);
    hConc->Draw("samePE");
    c1->GetPad(4)->Modified();    
    c1->GetPad(4)->Update();
    
    c1->cd(5);
    title = "conc ";  
    title = title + cut4;
    hConc = new TH1F("hConc",title,nbin, min, max);
    t2->Draw(var,cut4,"goff");
    hConc->SetNormFactor(1.);
    hConc->SetMarkerStyle(20);
    hConc->SetMarkerSize(0.4);
    //hConc->SetLineStyle(2);
    hConc->Draw("samePE");
    c1->GetPad(5)->Modified();    
    c1->GetPad(5)->Update();
    
    c1->cd(6);
    title = "conc ";  
    title = title + cut5;
    hConc = new TH1F("hConc",title,nbin, min, max);
    t2->Draw(var,cut5,"goff");
    hConc->SetNormFactor(1.);
    hConc->SetMarkerStyle(20);
    hConc->SetMarkerSize(0.4);
    //hConc->SetLineStyle(2);
    hConc->Draw("samePE");
    c1->GetPad(6)->Modified();    
    c1->GetPad(6)->Update();
  
    c1->Print(psname); 

    /////////////////////////////////////////////////////////////////
    char* var="conc6>>hConc6";

    nbin = 40; min = 0.; max = 1.;

    c1->cd(1);
    title = "conc6 ";  
    hConc6 = new TH1F("hConc6",title,nbin, min, max);
    t->Draw(var,"","goff");
    hConc6->SetNormFactor(1.);
    hConc6->Draw("Ehist");
    c1->GetPad(1)->Update();    

    c1->cd(2);
    title = "conc6 ";  
    title = title + cut1;
    hConc6 = new TH1F("hConc6",title,nbin, min, max);
    t->Draw(var,cut1,"goff");  
    hConc6->SetNormFactor(1.);
    hConc6->Draw("Ehist");  
    c1->GetPad(2)->Update();
    
    c1->cd(3);
    title = "conc6 ";  
    title = title + cut2;
    hConc6 = new TH1F("hConc6",title,nbin, min, max);
    t->Draw(var,cut2,"goff");
    hConc6->SetNormFactor(1.);
    hConc6->Draw("Ehist");
    c1->GetPad(3)->Update();
    
    c1->cd(4);
    title = "conc6 ";  
    title = title + cut3;
    hConc6 = new TH1F("hConc6",title,nbin, min, max);
    t->Draw(var,cut3,"goff");
    hConc6->SetNormFactor(1.);
    hConc6->Draw("Ehist");
    c1->GetPad(4)->Update();
    
    c1->cd(5);
    title = "conc6 ";  
    title = title + cut4;
    hConc6 = new TH1F("hConc6",title,nbin, min, max);
    t->Draw(var,cut4,"goff");
    hConc6->SetNormFactor(1.);
    hConc6->Draw("Ehist");
    c1->GetPad(5)->Update();
    
    c1->cd(6);
    title = "conc6 ";  
    title = title + cut5;
    hConc6 = new TH1F("hConc6",title,nbin, min, max);
    t->Draw(var,cut5,"goff");
    hConc6->SetNormFactor(1.);
    hConc6->Draw("Ehist");
    c1->GetPad(6)->Update();

    //offdata

    c1->cd(1);
    title = "conc6 ";  
    hConc6 = new TH1F("hConc6",title,nbin, min, max);
    t2->Draw(var,"","goff");
    hConc6->SetNormFactor(1.);
    hConc6->SetMarkerStyle(20);
    hConc6->SetMarkerSize(0.4);
    //hConc6->SetLineStyle(2);
    hConc6->Draw("samePE");
    c1->GetPad(1)->Modified();    
    c1->GetPad(1)->Update();    

    c1->cd(2);
    title = "conc6 ";  
    title = title + cut1;
    hConc6 = new TH1F("hConc6",title,nbin, min, max);
    t2->Draw(var,cut1,"goff");
    hConc6->SetNormFactor(1.);
    hConc6->SetMarkerStyle(20);
    hConc6->SetMarkerSize(0.4);
    //hConc6->SetLineStyle(2);
    hConc6->Draw("samePE");
    c1->GetPad(2)->Modified();        
    c1->GetPad(2)->Update();
    
    c1->cd(3);
    title = "conc6 ";  
    title = title + cut2;
    hConc6 = new TH1F("hConc6",title,nbin, min, max);
    t2->Draw(var,cut2,"goff");
    hConc6->SetNormFactor(1.);
    hConc6->SetMarkerStyle(20);
    hConc6->SetMarkerSize(0.4);
    //hConc6->SetLineStyle(2);
    hConc6->Draw("samePE");
    c1->GetPad(3)->Modified();    
    c1->GetPad(3)->Update();
    
    c1->cd(4);
    title = "conc6 ";  
    title = title + cut3;
    hConc6 = new TH1F("hConc6",title,nbin, min, max);
    t2->Draw(var,cut3,"goff");
    hConc6->SetNormFactor(1.);
    hConc6->SetMarkerStyle(20);
    hConc6->SetMarkerSize(0.4);
    //hConc6->SetLineStyle(2);
    hConc6->Draw("samePE");
    c1->GetPad(4)->Modified();    
    c1->GetPad(4)->Update();
    
    c1->cd(5);
    title = "conc6 ";  
    title = title + cut4;
    hConc6 = new TH1F("hConc6",title,nbin, min, max);
    t2->Draw(var,cut4,"goff");
    hConc6->SetNormFactor(1.);
    hConc6->SetMarkerStyle(20);
    hConc6->SetMarkerSize(0.4);
    // hConc6->SetLineStyle(2);
    hConc6->Draw("samePE");
    c1->GetPad(5)->Modified();    
    c1->GetPad(5)->Update();
    
    c1->cd(6);
    title = "conc6 ";  
    title = title + cut5;
    hConc6 = new TH1F("hConc6",title,nbin, min, max);
    t2->Draw(var,cut5,"goff");
    hConc6->SetNormFactor(1.);
    hConc6->SetMarkerStyle(20);
    hConc6->SetMarkerSize(0.4);
    //hConc6->SetLineStyle(2);
    hConc6->Draw("samePE");
    c1->GetPad(6)->Modified();    
    c1->GetPad(6)->Update();

    c1->Print(psname); 

    /////////////////////////////////////////////////////////////////
    char* var="alpha>>hAlpha";

    nbin = 18; min = 0.; max = 90.;
    
    c1->cd(1);
    title = "alpha ";  
    hAlpha = new TH1F("hAlpha",title,nbin, min, max);
    t->Draw(var, "", "goff");
    hAlpha->SetXTitle("degrees");
    hAlpha->SetNormFactor(1);
    hAlpha->Draw("Ehist");
    c1->GetPad(1)->Update();    

    c1->cd(2);
    title = "alpha ";  
    title = title + cut1;
    hAlpha = new TH1F("hAlpha",title,nbin, min, max);
    t->Draw(var,cut1, "goff");
    hAlpha->SetXTitle("degrees");
    hAlpha->SetNormFactor(1);
    hAlpha->Draw("Ehist");    
    c1->GetPad(2)->Update();
    
    c1->cd(3);
    title = "alpha ";  
    title = title + cut2;
    hAlpha = new TH1F("hAlpha",title,nbin, min, max);
    t->Draw(var,cut2, "goff");
    hAlpha->SetXTitle("degrees");
    hAlpha->SetNormFactor(1);
    hAlpha->Draw("Ehist");
    c1->GetPad(3)->Update();
    
    c1->cd(4);
    title = "alpha ";  
    title = title + cut3;
    hAlpha = new TH1F("hAlpha",title,nbin, min, max);
    t->Draw(var,cut3, "goff");
    hAlpha->SetXTitle("degrees");
    hAlpha->SetNormFactor(1);
    hAlpha->Draw("Ehist");
    c1->GetPad(4)->Update();
    
    c1->cd(5);
    title = "alpha ";  
    title = title + cut4;
    hAlpha = new TH1F("hAlpha",title,nbin, min, max);
    t->Draw(var,cut4, "goff");
    hAlpha->SetXTitle("degrees");
    hAlpha->SetNormFactor(1);
    hAlpha->Draw("Ehist");
    c1->GetPad(5)->Update();
    
    c1->cd(6);
    title = "alpha ";  
    title = title + cut5;
    hAlpha = new TH1F("hAlpha",title,nbin, min, max);
    t->Draw(var,cut5, "goff");
    hAlpha->SetXTitle("degrees");
    hAlpha->SetNormFactor(1);
    hAlpha->Draw("Ehist");
    c1->GetPad(6)->Update();

    //offdata

    c1->cd(1);
    title = "alpha ";  
    hAlpha = new TH1F("hAlpha",title,nbin, min, max);
    t2->Draw(var, "", "goff");
    hAlpha->SetXTitle("degrees");
    //hAlpha->SetLineStyle(2);
    hAlpha->SetNormFactor(1);
    hAlpha->SetMarkerStyle(20);
    hAlpha->SetMarkerSize(0.4);
    hAlpha->Draw("samePE");
    c1->GetPad(1)->Modified();    
    c1->GetPad(1)->Update();    

    c1->cd(2);
    title = "alpha ";  
    title = title + cut1;
    hAlpha = new TH1F("hAlpha",title,nbin, min, max);
    t2->Draw(var,cut1, "goff");
    hAlpha->SetXTitle("degrees");
    //hAlpha->SetLineStyle(2);
    hAlpha->SetMarkerStyle(20);
    hAlpha->SetMarkerSize(0.4);
    hAlpha->SetNormFactor(1);
    hAlpha->Draw("samePE");    
    c1->GetPad(2)->Modified();    
    c1->GetPad(2)->Update();
    
    c1->cd(3);
    title = "alpha ";  
    title = title + cut2;
    hAlpha = new TH1F("hAlpha",title,nbin, min, max);
    t2->Draw(var,cut2, "goff");
    hAlpha->SetXTitle("degrees");
    //hAlpha->SetLineStyle(2);
    hAlpha->SetNormFactor(1);
    hAlpha->SetMarkerStyle(20);
    hAlpha->SetMarkerSize(0.4);
    hAlpha->Draw("samePE");
    c1->GetPad(3)->Modified();    
    c1->GetPad(3)->Update();
    
    c1->cd(4);
    title = "alpha ";  
    title = title + cut3;
    hAlpha = new TH1F("hAlpha",title,nbin, min, max);
    t2->Draw(var,cut3, "goff");
    hAlpha->SetXTitle("degrees");
    //hAlpha->SetLineStyle(2);
    hAlpha->SetMarkerStyle(20);
    hAlpha->SetMarkerSize(0.4);
    hAlpha->SetNormFactor(1);
    hAlpha->Draw("samePE");
    c1->GetPad(4)->Modified();    
    c1->GetPad(4)->Update();
    
    c1->cd(5);
    title = "alpha ";  
    title = title + cut4;
    hAlpha = new TH1F("hAlpha",title,nbin, min, max);
    t2->Draw(var,cut4, "goff");
    hAlpha->SetXTitle("degrees");
    //hAlpha->SetLineStyle(2);
    hAlpha->SetMarkerStyle(20);
    hAlpha->SetMarkerSize(0.4);
    hAlpha->SetNormFactor(1);
    hAlpha->Draw("samePE");
    c1->GetPad(5)->Modified();    
    c1->GetPad(5)->Update();
    
    c1->cd(6);
    title = "alpha ";  
    title = title + cut5;
    hAlpha = new TH1F("hAlpha",title,nbin, min, max);
    t2->Draw(var,cut5, "goff");
    hAlpha->SetXTitle("degrees");
    //hAlpha->SetLineStyle(2);
    hAlpha->SetMarkerStyle(20);
    hAlpha->SetMarkerSize(0.4);
    hAlpha->SetNormFactor(1);
    hAlpha->Draw("samePE");
    c1->GetPad(6)->Modified();    
    c1->GetPad(6)->Update();

    c1->Print(psname); 

    /////////////////////////////////////////////////////////////////
    //                     Cuts in Dist
    /////////////////////////////////////////////////////////////////

    TCanvas *c2 = new TCanvas("c2","Cuts in Dist",500,800);
    c2->Divide(2,3);
    /////////////////////////////////////////////////////////////////
    char* var="length>>hLength";

    nbin = 40; min = 0.; max = 1.;

    c2->cd(1);
    //    c2->GetPad(1)->SetGrid();    
    title = "length "; 
    hLength = new TH1F("hLength",title,nbin, min, max);
    t->Draw(var, "", "goff");
    hLength->SetXTitle("degrees");
    hLength->SetNormFactor(1);
    hLength->Draw("Ehist");
    c2->GetPad(1)->Update();
 
    c2->cd(2);
    //c2->GetPad(2)->SetGrid();    
    title = "length ";  
    title = title + cutDist;
    hLength = new TH1F("hLength",title,nbin, min, max);
    t->Draw(var,cutDist, "goff");
    hLength->SetXTitle("degrees");
    hLength->SetNormFactor(1);
    hLength->Draw("Ehist");
    c2->GetPad(2)->Update();

    //offdata
        
    c2->cd(1);
    c2->GetPad(1)->SetGrid();    
    title = "length "; 
    hLength = new TH1F("hLength",title,nbin, min, max);
    t2->Draw(var, "", "goff");
    hLength->SetXTitle("degrees");
    //   hLength->SetLineStyle(2);
    hLength->SetMarkerStyle(20);
    hLength->SetMarkerSize(0.4);
    hLength->SetNormFactor(1);
    hLength->Draw("samePE");
    c2->GetPad(1)->Modified();    
    c2->GetPad(1)->Update();
 
    c2->cd(2);
    c2->GetPad(2)->SetGrid();    
    title = "length ";  
    title = title + cutDist;
    hLength = new TH1F("hLength",title,nbin, min, max);
    t2->Draw(var,cutDist, "goff");
    hLength->SetXTitle("degrees");
    hLength->SetMarkerStyle(20);
    hLength->SetMarkerSize(0.4);
    //hLength->SetLineStyle(2);
    hLength->SetNormFactor(1);
    hLength->Draw("samePE");
    c2->GetPad(1)->Modified();    
    c2->GetPad(2)->Update();

    /////////////////////////////////////////////////////////////////
    char* var="width>>hWidth";

    nbin = 40; min = 0.; max = 1.;

    c2->cd(3);
    c2->GetPad(3)->SetGrid();    
    title = "width ";  
    hWidth = new TH1F("hWidth",title,nbin, min, max);
    t->Draw(var, "", "goff");
    hWidth->SetXTitle("degrees");
    hWidth->SetNormFactor(1);
    hWidth->Draw("Ehist");
    c2->GetPad(3)->Update();
    
    c2->cd(4);
    c2->GetPad(4)->SetGrid();    
    title = "width ";  
    title = title + cutDist;
    hWidth = new TH1F("hWidth",title,nbin, min, max);
    t->Draw(var,cutDist, "goff");
    hWidth->SetXTitle("degrees");
    hWidth->SetNormFactor(1);
    hWidth->Draw("Ehist");
    c2->GetPad(4)->Update();
    
    //offdata

    c2->cd(3);
    c2->GetPad(3)->SetGrid();    
    title = "width ";  
    hWidth = new TH1F("hWidth",title,nbin, min, max);
    t2->Draw(var, "", "goff");
    hWidth->SetXTitle("degrees");
    //hWidth->SetLineStyle(2);
    hWidth->SetMarkerStyle(20);
    hWidth->SetMarkerSize(0.4);
    hWidth->SetNormFactor(1);
    hWidth->Draw("samePE");
    c2->GetPad(3)->Modified();    
    c2->GetPad(3)->Update();
    
    c2->cd(4);
    c2->GetPad(4)->SetGrid();    
    title = "width ";  
    title = title + cutDist;
    hWidth = new TH1F("hWidth",title,nbin, min, max);
    t2->Draw(var,cutDist, "goff");
    hWidth->SetXTitle("degrees");
    //hWidth->SetLineStyle(2);
    hWidth->SetMarkerStyle(20);
    hWidth->SetMarkerSize(0.4);
    hWidth->SetNormFactor(1);
    hWidth->Draw("samePE");
    c2->GetPad(4)->Modified();    
    c2->GetPad(4)->Update();

    /////////////////////////////////////////////////////////////////
    char* var="conc>>hConc";

    nbin = 40; min = 0.; max = 1.;

    c2->cd(5);
    c2->GetPad(5)->SetGrid();    
    title = "conc ";  
    hConc = new TH1F("hConc",title,nbin, min, max);
    t->Draw(var,"","goff");
    hConc->SetNormFactor(1.);
    hConc->Draw("Ehist");
    c2->GetPad(5)->Update();
    
    c2->cd(6);
    c2->GetPad(6)->SetGrid();    
    title = "conc ";  
    title = title + cutDist;
    hConc = new TH1F("hConc",title,nbin, min, max);
    t->Draw(var,cutDist,"goff");
    hConc->SetNormFactor(1.);
    hConc->Draw("Ehist");
    c2->GetPad(6)->Update();
    
    //offdata

    c2->cd(5);
    c2->GetPad(5)->SetGrid();    
    title = "conc ";  
    hConc = new TH1F("hConc",title,nbin, min, max);
    t2->Draw(var,"", "goff");
    //  hConc->SetLineStyle(2);
    hConc->SetMarkerStyle(20);
    hConc->SetMarkerSize(0.4);
    hConc->SetNormFactor(1.);
    hConc->Draw("samePE");
    c2->GetPad(5)->Modified();    
    c2->GetPad(5)->Update();
    
    c2->cd(6);
    c2->GetPad(6)->SetGrid();    
    title = "conc ";  
    title = title + cutDist;
    hConc = new TH1F("hConc",title,nbin, min, max);
    t2->Draw(var,cutDist,"goff");
    //hConc->SetLineStyle(2);
    hConc->SetMarkerStyle(20);
    hConc->SetMarkerSize(0.4);
    hConc->SetNormFactor(1.);
    hConc->Draw("samePE");
    c2->GetPad(6)->Modified();    
    c2->GetPad(6)->Update();
    
    c2->Print(psname); 

    /////////////////////////////////////////////////////////////////
    char* var="conc6>>hConc6";

    nbin = 40; min = 0.; max = 1.;

    c2->cd(1);
    title = "conc6 ";  
    hConc6 = new TH1F("hConc6",title,nbin, min, max);
    t->Draw(var,"","goff");
    hConc6->SetNormFactor(1.);
    hConc6->Draw("Ehist");
    c2->GetPad(1)->Update();
    
    c2->cd(2);
    title = "conc6 ";  
    title = title + cutDist;
    hConc6 = new TH1F("hConc6",title,nbin, min, max);
    t->Draw(var,cutDist,"goff");
    hConc6->SetNormFactor(1.);
    hConc6->Draw("Ehist");
    c2->GetPad(2)->Update();

    //offdata

    c2->cd(1);
    title = "conc6 ";  
    hConc6 = new TH1F("hConc6",title,nbin, min, max);
    t2->Draw(var,"","goff");
    //hConc6->SetLineStyle(2);
    hConc6->SetMarkerStyle(20);
    hConc6->SetMarkerSize(0.4);
    hConc6->SetNormFactor(1.);
    hConc6->Draw("samePE");
    c2->GetPad(1)->Modified();    
    c2->GetPad(1)->Update();
    
    c2->cd(2);
    title = "conc6 ";  
    title = title + cutDist;
    hConc6 = new TH1F("hConc6",title,nbin, min, max);
    t2->Draw(var,cutDist,"goff");
    // hConc6->SetLineStyle(2);
    hConc6->SetMarkerStyle(20);
    hConc6->SetMarkerSize(0.4);
    hConc6->SetNormFactor(1.);
    hConc6->Draw("samePE");
    c2->GetPad(2)->Modified();    
    c2->GetPad(2)->Update(); 
  
    /////////////////////////////////////////////////////////////////
    char* var="alpha>>hAlpha";

    nbin = 18; min = 0.; max = 90.;

    c2->cd(3);
    title = "alpha ";  
    hAlpha = new TH1F("hAlpha",title,nbin, min, max);
    t->Draw(var, "", "goff");
    hAlpha->SetXTitle("degrees");
    hAlpha->SetNormFactor(1);
    hAlpha->Draw("Ehist");
    c2->GetPad(3)->Update();
    
    c2->cd(4);
    title = "alpha ";  
    title = title + cutDist;
    hAlpha = new TH1F("hAlpha",title,nbin, min, max);
    t->Draw(var,cutDist, "goff");
    hAlpha->SetXTitle("degrees");
    hAlpha->SetNormFactor(1);
    hAlpha->Draw("Ehist");
    c2->GetPad(4)->Update();
   
    //offdata

    c2->cd(3);
    title = "alpha ";  
    hAlpha = new TH1F("hAlpha",title,nbin, min, max);
    t2->Draw(var, "", "goff");
    hAlpha->SetXTitle("degrees");
    //hAlpha->SetLineStyle(2);
    hAlpha->SetMarkerStyle(20);
    hAlpha->SetMarkerSize(0.4);
    hAlpha->SetNormFactor(1);
    hAlpha->Draw("samePE");
    c2->GetPad(3)->Modified();    
    c2->GetPad(3)->Update();
    
    c2->cd(4);
    title = "alpha ";  
    title = title + cutDist;
    hAlpha = new TH1F("hAlpha",title,nbin, min, max);
    t2->Draw(var,cutDist, "goff");
    hAlpha->SetXTitle("degrees");
    //hAlpha->SetLineStyle(2);
    hAlpha->SetMarkerStyle(20);
    hAlpha->SetMarkerSize(0.4);
    hAlpha->SetNormFactor(1);
    hAlpha->Draw("samePE");
    c2->GetPad(4)->Modified();    
    c2->GetPad(4)->Update();


    /////////////////////////////////////////////////////////////////
    char* var="log10(size)>>hSize";

    nbin = 40; min = 0.5; max = 4.5;

    c2->cd(5);
    c2->GetPad(5)->SetLogy(); 
    title = "size ";  
    hSize = new TH1F("hSize",title,nbin, min, max);
    t->Draw(var, "1/MHillas.fSize", "goff");
    hSize->SetNormFactor(1.);
    hSize->SetXTitle("log10(ADC counts)");
    hSize->Draw("Ehist");
    c2->GetPad(5)->Update();
    
    c2->cd(6);
    c2->GetPad(6)->SetLogy(); 
    title = "size ";  
    title = title + cutDist;
    hSize = new TH1F("hSize",title,nbin, min, max);
    t->Draw(var,"1/MHillas.fSize*(MHillasSrc.fDist*0.6/189.>0.2 && MHillasSrc.fDist*0.6/189<0.8)", "goff");
    hSize->SetXTitle("log10(ADC counts)");
    hSize->SetNormFactor(1.);
    hSize->Draw("Ehist");
    c2->GetPad(6)->Update(); 

    //offdata
    c2->cd(5);
    c2->GetPad(5)->SetLogy(); 
    title = "size ";  
    hSize = new TH1F("hSize",title,nbin, min, max);
    t2->Draw(var, "1/MHillas.fSize", "goff");
    hSize->SetXTitle("log10(ADC counts)");
    hSize->SetNormFactor(1.);
    hSize->SetMarkerStyle(20);
    hSize->SetMarkerSize(0.4);
    //hSize->SetLineStyle(2);
    hSize->Draw("samePE");
    c2->GetPad(5)->Modified();    
    c2->GetPad(5)->Update();
    
    c2->cd(6);
    c2->GetPad(6)->SetLogy(); 
    title = "size ";  
    title = title + cutDist;
    hSize = new TH1F("hSize",title,nbin, min, max);
    t2->Draw(var,"1/MHillas.fSize*(MHillasSrc.fDist*0.6/189.>0.2 && MHillasSrc.fDist*0.6/189<0.8)", "goff");
    hSize->SetXTitle("log10(ADC counts)");
    //hSize->SetLineStyle(2);
    hSize->SetNormFactor(1.);
    hSize->SetMarkerStyle(20);
    hSize->SetMarkerSize(0.4);
    hSize->Draw("samePE");
    c2->GetPad(6)->Modified();    
    c2->GetPad(6)->Update(); 
       
    c2->Print(closepsname);                                                    
  
}



