/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 <mailto:tbretz@uni-sw.gwdg.de>
!              Markus Gaug   04/2004 <mailto:markus@ifae.es>               
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MPedestalPix                                                            //
//                                                                         //
// This is the storage container to hold informations about the pedestal   //
// (offset) value of one Pixel (PMT).                                      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MPedestalPix.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MPedestalPix);

using namespace std;

MPedestalPix::MPedestalPix()
    : fValid(kTRUE)
{
  Clear();
}


// ------------------------------------------------------------------------
//
// Invalidate values
//
void MPedestalPix::Clear(Option_t *o)
{
  fPedestal    = -1.;
  fPedestalRms = -1.;
}

void MPedestalPix::InitUseHists()
{

  fPedestal    = 0.;
  fPedestalRms = 0.;
}


void MPedestalPix::Set(Float_t m, Float_t r)
{
  fPedestal    = m; 
  fPedestalRms = r; 
}

Bool_t MPedestalPix::IsValid() const 
{

  if (!fValid)
    return kFALSE;

 return fPedestal>=0||fPedestalRms>=0;
}

