#ifndef MARS_MExtractBlindPixel
#define MARS_MExtractBlindPixel

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MExtractBlindPixel                                                      //
//                                                                         //
// Integrates the time slices of the all pixels of a calibration event     //
// and substract the pedestal value                                        //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MExtractor
#include "MExtractor.h"
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

class MExtractedSignalBlindPixel;
class MExtractBlindPixel : public MExtractor
{
private:

  static const Int_t  fgBlindPixelIdx;
  static const Int_t  fgNSBFilterLimit;  
  static const Byte_t fgHiGainFirst;     // First FADC slice Hi-Gain (currently set to: 0) 
  static const Byte_t fgHiGainLast;      // Last FADC slice Hi-Gain (currently set to: 11) 
  static const Byte_t fgLoGainFirst;     // First FADC slice Lo-Gain (currently set to: 0) 
  static const Byte_t fgLoGainLast;      // Last FADC slice Lo-Gain (currently set to:  2) 
  static const Float_t fgResolution;     // Default for fResolution   (now set to: 0.003)
  
  MExtractedSignalBlindPixel  *fBlindPixel;   // Extracted signal of the Blind Pixel

  Byte_t  fHiLoFirst;
  Float_t *fHiGainSignal;                     // Need fast access to the signals in a float way
  Float_t *fHiGainFirstDeriv;
  Float_t *fHiGainSecondDeriv;

  Float_t fResolution;                        // The time resolution in FADC units
  TArrayI fBlindPixelIdx;
  Int_t   fNSBFilterLimit;  

  void FindAmplitude(Byte_t *firstused, Byte_t *lowgain, Float_t &sum, Byte_t &sat) const;
  void FindSignalHiGain(Byte_t *firstused, Byte_t *lowgain, Float_t &sum, Byte_t &sat) const;
  void FindSignalFilter(Byte_t *ptr, Int_t &sum, Byte_t &sat) const;
  
  Int_t  PreProcess(MParList *pList);
  Bool_t ReInit(MParList *pList);
  Int_t  Process();

public:

  MExtractBlindPixel(const char *name=NULL, const char *title=NULL);
  ~MExtractBlindPixel();
  
  // Setters
  void SetRange(Byte_t hifirst=0, Byte_t hilast=0, Byte_t lofirst=0, Byte_t lolast=0);
  void SetBlindPixelIdx(  const  Int_t idx=fgBlindPixelIdx, const Int_t nr=0) {
    if (nr>fBlindPixelIdx.GetSize()+1)
      fBlindPixelIdx.Set(nr+1);
    fBlindPixelIdx.AddAt(idx,nr); }
  void SetNSBFilterLimit(  const  Int_t lim=fgNSBFilterLimit ) { fNSBFilterLimit     = lim; }    
  void SetResolution(Float_t f=fgResolution)     { fResolution = f;  }
  
  ClassDef(MExtractBlindPixel, 0) // Signal Extractor for the Blind Pixel
};

#endif

