/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Eva Domingo  02/2004 <mailto:domingo@ifae.es>
!   Author(s): Josep Flix   02/2004 <mailto:jflix@ifae.es>
!
!   Copyright: MAGIC Software Development, 2004
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// MDisp
//
// Storage Container for image parameters
//
//    Disp method for extended sources analysis related image parameters
//
//
// Version 1:
// ----------
//  fDisp          Distance along the major axis from the centroid to the suspected position of the source
//  fPosDisp1      Position of Disp evaluated point 1 in the camera in [mm]
//  fPosDisp2      Position of Disp evaluated point 2 in the camera in [mm]
//
//
/////////////////////////////////////////////////////////////////////////////

#include "MDisp.h"

#include <iostream.h>
//#include <TArrayF.h>

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MDisp);


// --------------------------------------------------------------------------
//
// Default constructor.
//
MDisp::MDisp(const char *name, const char *title)
{
    fName  = name  ? name  : "MDisp";
    fTitle = title ? title : "Parameter related to Disp method for extended sources analysis";

}

void MDisp::SetPosDisp(char *var, Float_t value)
{

    if ( !strcmp(var,"X1") )
	fX1 = value;
    else if ( !strcmp(var,"Y1") )
	fY1 = value;
    else if ( !strcmp(var,"X2") )
	fX2 = value;
    else if ( !strcmp(var,"Y2") )
	fY2 = value;  
    else
	cout << "SetPosDisp:: Coordinate argument WRONG!" << endl;

};


Float_t MDisp::GetPosDisp(char *var)
{

    if ( !strcmp(var,"X1") )
	return fX1;
    else if ( !strcmp(var,"Y1") )
	return fY1;
    else if ( !strcmp(var,"X2") )
	return fX2;
    else if ( !strcmp(var,"Y2") )
	return fY2;  
    else
    {
	cout << "GetPosDisp:: Coordinate argument WRONG!" << endl;
	return -9999.;
    }
};


void MDisp::Print(Option_t *opt) const
{
      *fLog << all << GetDescriptor() << ":" << endl;
      *fLog << "Disp [mm] = " << fDisp << ": ";
      *fLog << "DX1 [mm] = " << fX1 << ": ";
      *fLog << "DY1 [mm] = " << fY1 << ": ";
      *fLog << "DX2 [mm] = " << fX2 << ": ";
      *fLog << "DY2 [mm] = " << fY2 << ": ";
      *fLog << "PsiEvent[mm] =" << fPsiEvent << ": " << endl;  
};
