/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 <mailto:tbretz@uni-sw.gwdg.de>
!              Florian Goebel 07/2004
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */


Bool_t HandleInput()
{
  TTimer timer("gSystem->ProcessEvents();", 50, kFALSE);
  while (1)
    {
      //
      // While reading the input process gui events asynchronously
      //
      timer.TurnOn();
      TString input = Getline("Type 'q' to exit, <return> to go on: ");
      timer.TurnOff();
      
      if (input=="q\n")
	return kFALSE;
      
      if (input=="\n")
	return kTRUE;
    };
  
  return kFALSE;
}

const TString defname = "/.magic/magicserv01/MAGIC/rootdata2/2004_04_22/20040422_23211_D_Mrk421_E.root";
const TString defpedname = "/.magic/magicserv01/MAGIC/rootdata2/2004_04_22/20040422_23209_P_Mrk421_E.root";

void ScanExtractSignalABCorr(const TString fname = defname,  const TString pedname = defpedname) {
  
  MParList plist_ped;
  
  MTaskList tlist_ped;
  plist_ped.AddToList(&tlist_ped);
  
  MPedestalCam   pedcam;
  plist_ped.AddToList(&pedcam);
  
  MReadMarsFile read("Events", pedname);
  read.DisableAutoScheme();
  
  MGeomApply    geomapl_ped;
  MGeomCamMagic geomcam_ped;

  MPedCalcFromLoGain pedcalc_ped;
  pedcalc_ped.SetPedestalUpdate(kFALSE);
  
  tlist_ped.AddToList(&read);
  tlist_ped.AddToList(&geomapl_ped);
  tlist_ped.AddToList(&pedcalc_ped);
  
  MEvtLoop evtloop_ped;
  evtloop_ped.SetParList(&plist_ped);
  
  if (!evtloop_ped.Eventloop())
    return;
  
  tlist_ped.PrintStatistics();
  
  
  // now the event loop for the signal reconstruction with pedestals subtracted
  
  
  MParList plist;
  MTaskList     tlist;
  //  MPedestalCam   pedcam;
  plist.AddToList(&pedcam);
  
  MRawEvtData evtdata; 
  plist.AddToList(&evtdata);
  
  MArrivalTimeCam timecam;
  plist.AddToList(&timecam);
  
  MExtractedSignalCam sigcam;
  plist.AddToList(&sigcam);
  
  
  plist.AddToList(&tlist);
  
  MReadMarsFile read("Events", fname);
  read.DisableAutoScheme();
  
  MGeomApply       geomapl;
  MArrivalTimeCalc timetime;

  MExtractSignalABcorr sigsig;
  sigsig.SetRange(5,7,5,7);
  
  tlist.AddToList(&read);
  tlist.AddToList(&geomapl);
  tlist.AddToList(&sigsig);
  tlist.AddToList(&timetime);
  
  
  
  MEvtLoop evtloop;
  evtloop.SetParList(&plist);
  
  if (!evtloop.PreProcess())
    return;
  
  
  MGeomCam *geomcam = (MGeomCam*)plist->FindObject("MGeomCam");
  
  MHCamera display;
  TCanvas c("Events", "Real Events", 600, 600);
  c.SetBorderMode(0);
  c.Divide(1,1);
  
  MHCamera display_time;
  TCanvas c_time("Events_time", "Events Time", 600, 600);
  c_time.SetBorderMode(0);
  c_time.Divide(1,1);
  
  
  display.SetGeometry(*geomcam);
  display.SetPrettyPalette();
  c.cd(1);
  display.Draw();
  gPad->cd(1);
  
  display_time.SetGeometry(*geomcam);
  display_time.SetPrettyPalette();
  c_time.cd(1);
  display_time.Draw();
  gPad->cd(1);
  
  
  // Use this if you don't want the event to be autoscaled
  //display.SetMinimum(0);
  //display.SetMaximum(100);
  

  while (tlist.Process()) {
    cout << "Event #" << read.GetNumEntry() ":" << endl;
      
      display.SetCamContent(sigcam,0);
      display.SetCamError(sigcam,1);
      
      c.GetPad(1)->GetPad(1)->Modified(); //vielleicht fehler? 1->i ??
      c.GetPad(1)->GetPad(1)->Update();
      
      
      display_time.SetCamContent(timecam,0);
      display_time.SetCamError(timecam,1);
      c_time.GetPad(1)->GetPad(1)->Modified(); //vielleicht fehler? 1->i ??
      c_time.GetPad(1)->GetPad(1)->Update();
            
      if (!HandleInput())
      	break;
  }
  
  evtloop.PostProcess();

  TCanvas c("Events", "Real Events", 600, 600);
  c.SetBorderMode(0);
  c.Divide(1,1);
  c.cd(1);

  chargevpixel->Draw();

}







