#ifndef MARS_MJExtractCalibTest
#define MARS_MJExtractCalibTest

#ifndef MARS_MHCalibrationTestCam
#include "MHCalibrationTestCam.h"
#endif
#ifndef MARS_MHCalibrationTestTimeCam
#include "MHCalibrationTestTimeCam.h"
#endif
#ifndef MARS_MPedPhotCam
#include "MPedPhotCam.h"
#endif
#ifndef MARS_MBadPixelsCam
#include "MBadPixelsCam.h"
#endif

class MRunIter;
class MParList;
class MPedestalCam;
class MCalibrationRelTimeCam;
class MCalibrationChargeCam;
class MCalibrationQECam;
class MExtractor;
class MExtractTime;
class MJExtractCalibTest : public MParContainer
{
private:

  TString fOutputPath;
  Bool_t  fUseCosmicsFilter;
  
  MRunIter     *fRuns;                       // Data files
  MExtractor   *fExtractor;                  // Signal extractor
  MExtractTime *fTimeExtractor;              // Arrival time extractor  
  
  MBadPixelsCam            fBadPixels;
  MHCalibrationTestCam     fTestCam;
  MHCalibrationTestTimeCam fTestTimeCam;
  MPedPhotCam              fPedPhotCam;

  Bool_t ReadPedPhotCam();
  
  void   DisplayResult(MParList &plist);
  void   DisplayResultT(MParList &plist);

  Bool_t WriteResultD();
  Bool_t WriteResultT();
  
  Bool_t ProcessFileD(MPedestalCam &pedcam, MCalibrationChargeCam &calcam, MCalibrationQECam &qecam);
  Bool_t ProcessFileT(MPedestalCam &pedcam, MCalibrationRelTimeCam &relcam);  

public:
  MJExtractCalibTest(const char *name=NULL, const char *title=NULL);
  
  void SetInput(MRunIter *iter) { fRuns = iter; }
  void SetOutputPath(const char *path=".");
  
  const char* GetOutputFile() const;
  
  MHCalibrationTestCam     &GetTestCam()      { return fTestCam; }
  MHCalibrationTestTimeCam &GetTestTimeCam()  { return fTestTimeCam; }  
  MPedPhotCam          &GetPedPhotCam() { return fPedPhotCam; }
  const MBadPixelsCam &GetBadPixels()  const { return fBadPixels; }
  
  void SetExtractor(MExtractor* ext)              { fExtractor = ext; }
  void SetTimeExtractor(MExtractTime* ext)         { fTimeExtractor = ext; }
  void SetBadPixels(const MBadPixelsCam &bad) { bad.Copy(fBadPixels); }
  void SetUseCosmicsFilter( const Bool_t b )    { fUseCosmicsFilter = b;  }
     
  Bool_t ProcessD(MPedestalCam &pedcam, MCalibrationChargeCam &calcam, MCalibrationQECam &qecam);
  Bool_t ProcessT(MPedestalCam &pedcam, MCalibrationRelTimeCam &relcam);  
  
  ClassDef(MJExtractCalibTest, 0) // Tool to extract, calibrate and test the signal 
};

#endif
