#ifndef MARS_MHCamEvent
#define MARS_MHCamEvent

#ifndef MARS_MH
#include "MH.h"
#endif

class MHCamera;
class MCamEvent;

class MHCamEvent : public MH
{
private:
    MHCamera  *fSum; // storing the sum
    MHCamera  *fRms; // storing the rms
    MCamEvent *fEvt; //! the current event

    TString fNameEvt;

    Int_t fType;

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);
    Bool_t Finalize();

public:
    MHCamEvent(const char *name=NULL, const char *title=NULL);
    ~MHCamEvent();

    void SetNameEvt(const TString name) { fNameEvt = name; }
    void SetType(Int_t type) { fType = type; }

    TH1 *GetHistByName(const TString name="");

    void Draw(Option_t *o="");

    void PrintOutliers(Float_t s) const;

    ClassDef(MHCamEvent, 1) // Histogram to sum camera events
};

#endif
