#include <errno.h>
#include <fstream>

#include "MLog.h"

using namespace std;

static void Usage()
{
    gLog << endl;
    gLog << "Sorry the usage is:" << endl;
    gLog << "   showlog filename" << endl;
    gLog << " or" << endl;
    gLog << "   showlog < filename" << endl << endl;
    gLog << " This program converts colored output made with ansi codes" << endl;
    gLog << " (like it is done by MLog) and redirected into a file back" << endl;
    gLog << " into colored output." << endl << endl;
}

// FIXME: Enhance this tool with a converter to HTMl, etc.
//        Add option for 'no-colors'
int main(int argc, char **argv)
{
    if (argc>2)
    {
        Usage();
        return -1;
    }

    istream *in = argc==2 ? new ifstream(argv[1]) : &cin;
    if (!*in)
    {
        gLog << "Cannot open file " << argv[1] << ": " << strerror(errno) << endl;
        return -1;
    }

    TString s;
    while (1)
    {
        s.ReadLine(*in);
        if (!*in)
            break;

        s.ReplaceAll("", "\033");
        gLog << s << endl;
    }

    if (in!=&cin)
        delete in;

    return 0;
}
