#ifndef MARS_MHillasCalc
#define MARS_MHillasCalc

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MHillasCalkc                                                            //
//                                                                         //
// Task to calculate Hillas Parameters                                     //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif
#ifndef ROOT_TArrayL
#include <TArrayL.h>
#endif

class MGeomCam;
class MCerPhotEvt;
class MHillas;
class MHillasExt;
class MNewImagePar;
class MConcentration;

class MHillasCalc : public MTask
{
    const MGeomCam    *fGeomCam;    //! Camera Geometry used to calculate Hillas
    const MCerPhotEvt *fCerPhotEvt; //! Cerenkov Photon Event used for calculation

    MHillas           *fHillas;     //! output container to store result
    MHillasExt        *fHillasExt;  //! output container to store result
    MNewImagePar      *fNewImgPar;  //! output container to store result
    MConcentration    *fConc;       //! output container to store result

    TString            fNameHillas;    // name of the 'MHillas' container
    TString            fNameHillasExt; // name of the 'MHillasExt' container
    TString            fNameNewImgPar; // name of the 'MNewImagePar' container
    TString            fNameConc;      // name of the 'MConcentration' container

    Int_t              fFlags;      // Flags defining the behaviour of MHillasCalc

    TArrayL            fErrors;     //! Error counter. Do we have to change to Double?

    void  PrintSkipped(int i, const char *str) const;

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

public:
    enum CalcCont_t {
        kCalcHillas      = BIT(0),
        kCalcHillasExt   = BIT(1),
        //kCalcHillasSrc   = BIT(2),
        kCalcNewImagePar = BIT(3),
        kCalcConc        = BIT(4)
    };

    MHillasCalc(const char *name=NULL, const char *title=NULL);

    void   SetNameHillas(const char *name)    { fNameHillas = name;    }
    void   SetNameHillasExt(const char *name) { fNameHillasExt = name; }
    void   SetNameNewImgPar(const char *name) { fNameNewImgPar = name; }
    void   SetNameConc(const char *name)      { fNameConc = name;      }

    void   SetFlags(Int_t f) { fFlags  =  f; }
    void   Enable(Int_t f)   { fFlags |=  f; }
    void   Disable(Int_t f)  { fFlags &= ~f; }
    Bool_t TestFlag(CalcCont_t i) const { return fFlags&i; }

    ClassDef(MHillasCalc, 0) // Task to calculate Hillas and other image parameters
};

#endif
