#ifndef MARS_MCalibColorSet
#define MARS_MCalibColorSet

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MParList;
class MRawEvtHeader;

class MCalibColorSet : public MTask
{
private:
    static const Int_t gkIFAEBoxInaugurationRun; //! Run number of first IFAE box calibration

    MRawEvtHeader *fHeader;

    UInt_t fPattern;
    Bool_t fIsValid;

    Bool_t ReInit(MParList *pList);
    Int_t  PreProcess(MParList *pList);
    Int_t  Process();

public:
    MCalibColorSet(const char *name=NULL, const char *title=NULL);

    void Clear(const Option_t *o="");

    ClassDef(MCalibColorSet, 0) // Task to workaround missing colors
};
    
#endif

