/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug   07/2004 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                               
// MCalibrationChargeBlindCamTwoNewStyle                                               
//                                                               
// Blind Pixels Calibration camera after run 31693. The blind pixel camera 
// consisted then of two non-coated blind pixel with very well known 
// quantum efficiency read out in hardware ID 560 and 561.
//
// See also: MCalibrationChargeBlindCam
//
/////////////////////////////////////////////////////////////////////////////
#include "MCalibrationChargeBlindCamTwoNewStyle.h"
#include "MCalibrationChargeBlindPix.h"

ClassImp(MCalibrationChargeBlindCamTwoNewStyle);

using namespace std;

// --------------------------------------------------------------------------
//
// Default constructor. 
//
// - CreatePixs();
// - CreateAreas();   
// - CreateAtts();   
// - CreateQEs();     
// - CreateCollEffs();
//
MCalibrationChargeBlindCamTwoNewStyle::MCalibrationChargeBlindCamTwoNewStyle(const char *name)
    : MCalibrationChargeBlindCam(2,name,"Two Blind Pixels in camera - new style")
{

  CreatePixs    ();    
  CreateAreas   ();   
  CreateAtts    ();   
  CreateQEs     ();     
  CreateCollEffs();

}


// --------------------------------------------------------------------------
//
// Two blind pixels with ID 559 and 560 (software)
//
void MCalibrationChargeBlindCamTwoNewStyle::CreatePixs() 
{

  (*this)[0].SetPixId(559);
  (*this)[1].SetPixId(560);
  
}

// --------------------------------------------------------------------------
//
// Two blind pixels with exactly 100 mm^2 area
//
void MCalibrationChargeBlindCamTwoNewStyle::CreateAreas() 
{

  (*this)[0].SetArea(100.);
  (*this)[1].SetArea(100.);
  
}

// --------------------------------------------------------------------------
//
// Two blind pixels with very well known qe's: David's measurments with 
// 1% error.
//
void MCalibrationChargeBlindCamTwoNewStyle::CreateQEs() 
{
  
  (*this)[0].SetQE         ( 0.166,   MCalibrationCam::kGREEN );
  (*this)[0].SetQE         ( 0.240,   MCalibrationCam::kBLUE  );
  (*this)[0].SetQE         ( 0.273,   MCalibrationCam::kUV    );
  (*this)[0].SetQE         ( 0.273,   MCalibrationCam::kCT1   );

  (*this)[0].SetQEErr      ( 0.004,   MCalibrationCam::kGREEN );
  (*this)[0].SetQEErr      ( 0.005,   MCalibrationCam::kBLUE  );
  (*this)[0].SetQEErr      ( 0.006,   MCalibrationCam::kUV    );
  (*this)[0].SetQEErr      ( 0.006,   MCalibrationCam::kCT1   );

  (*this)[1].SetQE         ( 0.155,   MCalibrationCam::kGREEN );
  (*this)[1].SetQE         ( 0.228,   MCalibrationCam::kBLUE  );
  (*this)[1].SetQE         ( 0.261,   MCalibrationCam::kUV    );
  (*this)[1].SetQE         ( 0.261,   MCalibrationCam::kCT1   );

  (*this)[1].SetQEErr      ( 0.004,   MCalibrationCam::kGREEN );
  (*this)[1].SetQEErr      ( 0.005,   MCalibrationCam::kBLUE  );
  (*this)[1].SetQEErr      ( 0.006,   MCalibrationCam::kUV    );
  (*this)[1].SetQEErr      ( 0.006,   MCalibrationCam::kCT1   );

}

// --------------------------------------------------------------------------
//
// One blind pixel with poorly known coll.eff's: email from Eckart with 
// estimates depending on colour, but 5% error (maybe more??)
//
void MCalibrationChargeBlindCamTwoNewStyle::CreateCollEffs() 
{

  (*this)[0].SetCollEff    ( 0.99,   MCalibrationCam::kGREEN );
  (*this)[0].SetCollEff    ( 0.93,   MCalibrationCam::kBLUE  );
  (*this)[0].SetCollEff    ( 0.90,   MCalibrationCam::kUV    );
  (*this)[0].SetCollEff    ( 0.90,   MCalibrationCam::kCT1   );

  (*this)[0].SetCollEffErr ( 0.05,   MCalibrationCam::kGREEN );
  (*this)[0].SetCollEffErr ( 0.05,   MCalibrationCam::kBLUE  );
  (*this)[0].SetCollEffErr ( 0.05,   MCalibrationCam::kUV    );
  (*this)[0].SetCollEffErr ( 0.05,   MCalibrationCam::kCT1   );
  
  (*this)[1].SetCollEff    ( 0.99,   MCalibrationCam::kGREEN );
  (*this)[1].SetCollEff    ( 0.93,   MCalibrationCam::kBLUE  );
  (*this)[1].SetCollEff    ( 0.90,   MCalibrationCam::kUV    );
  (*this)[1].SetCollEff    ( 0.90,   MCalibrationCam::kCT1   );

  (*this)[1].SetCollEffErr ( 0.05,   MCalibrationCam::kGREEN );
  (*this)[1].SetCollEffErr ( 0.05,   MCalibrationCam::kBLUE  );
  (*this)[1].SetCollEffErr ( 0.05,   MCalibrationCam::kUV    );
  (*this)[1].SetCollEffErr ( 0.05,   MCalibrationCam::kCT1   );
  
  
}

// --------------------------------------------------------------------------
//
// One blind pixel has a very well known attenuation 0.01 (datasheet delivered 
// with filter, precision better than 1%
//
// The second blind pixel is not yet so well known, the company does not reply.
// Attenuation: 0.001 (datasheet not delivered with filter, precision guaranteed to 5%)
//
void MCalibrationChargeBlindCamTwoNewStyle::CreateAtts() 
{

  (*this)[0].SetAtt    ( 1.97,   MCalibrationCam::kGREEN );
  (*this)[0].SetAtt    ( 1.96,   MCalibrationCam::kBLUE  );
  (*this)[0].SetAtt    ( 1.95,   MCalibrationCam::kUV    );
  (*this)[0].SetAtt    ( 1.95,   MCalibrationCam::kCT1   );

  (*this)[0].SetAttErr ( 0.01,   MCalibrationCam::kGREEN );
  (*this)[0].SetAttErr ( 0.01,   MCalibrationCam::kBLUE  );
  (*this)[0].SetAttErr ( 0.01,   MCalibrationCam::kUV    );
  (*this)[0].SetAttErr ( 0.01,   MCalibrationCam::kCT1   );
  
  (*this)[1].SetAtt    ( 3.00,   MCalibrationCam::kGREEN );
  (*this)[1].SetAtt    ( 3.00,   MCalibrationCam::kBLUE  );
  (*this)[1].SetAtt    ( 3.00,   MCalibrationCam::kUV    );
  (*this)[1].SetAtt    ( 3.00,   MCalibrationCam::kCT1   );

  (*this)[1].SetAttErr ( 0.15,   MCalibrationCam::kGREEN );
  (*this)[1].SetAttErr ( 0.15,   MCalibrationCam::kBLUE  );
  (*this)[1].SetAttErr ( 0.15,   MCalibrationCam::kUV    );
  (*this)[1].SetAttErr ( 0.15,   MCalibrationCam::kCT1   );
  
}

