/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug   07/2004 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                               
// MCalibrationChargeBlindCamOneOldStyle                                               
//                                                               
// Blind Pixels Calibration camera until run 31693. The blind pixel camera 
// consisted then only of one non-coated blind pixel with poorly known 
// quantum efficiency read out in hardware ID 560.
//
// See also: MCalibrationChargeBlindCam
//
/////////////////////////////////////////////////////////////////////////////
#include "MCalibrationChargeBlindCamOneOldStyle.h"
#include "MCalibrationChargeBlindPix.h"

ClassImp(MCalibrationChargeBlindCamOneOldStyle);

using namespace std;

// --------------------------------------------------------------------------
//
// Default constructor. 
//
// - CreatePixs();
// - CreateAreas();   
// - CreateAtts();   
// - CreateQEs();     
// - CreateCollEffs();
//
MCalibrationChargeBlindCamOneOldStyle::MCalibrationChargeBlindCamOneOldStyle(const char *name)
    : MCalibrationChargeBlindCam(1,name,"One Blind Pixel in camera - old style")
{

  CreatePixs    ();    
  CreateAreas   ();   
  CreateAtts    ();   
  CreateQEs     ();     
  CreateCollEffs();

}


// --------------------------------------------------------------------------
//
// Only one blind pixel with ID 559
//
void MCalibrationChargeBlindCamOneOldStyle::CreatePixs() 
{

  (*this)[0].SetPixId(559);
  
}

// --------------------------------------------------------------------------
//
// Only one blind pixel with exactly 100 mm^2 area
//
void MCalibrationChargeBlindCamOneOldStyle::CreateAreas() 
{

  (*this)[0].SetArea(100.);
  
}

// --------------------------------------------------------------------------
//
// One blind pixel with poorly known qe's: average of David measurments with 
// 4% error.
//
void MCalibrationChargeBlindCamOneOldStyle::CreateQEs() 
{
  
  (*this)[0].SetQE         ( 0.154,      MCalibrationCam::kGREEN );
  (*this)[0].SetQE         ( 0.226,      MCalibrationCam::kBLUE  );
  (*this)[0].SetQE         ( 0.247,      MCalibrationCam::kUV    );
  (*this)[0].SetQE         ( 0.247,      MCalibrationCam::kCT1   );

  (*this)[0].SetQEErr      ( 0.005,   MCalibrationCam::kGREEN );
  (*this)[0].SetQEErr      ( 0.007,   MCalibrationCam::kBLUE  );
  (*this)[0].SetQEErr      ( 0.01,    MCalibrationCam::kUV    );
  (*this)[0].SetQEErr      ( 0.01,    MCalibrationCam::kCT1   );

}

// --------------------------------------------------------------------------
//
// One blind pixel with poorly known coll.eff's: email from Eckart with 
// estimates depending on colour, but 5% error (maybe more??)
//
void MCalibrationChargeBlindCamOneOldStyle::CreateCollEffs() 
{

  (*this)[0].SetCollEff    ( 0.99, MCalibrationCam::kGREEN );
  (*this)[0].SetCollEff    ( 0.93, MCalibrationCam::kBLUE  );
  (*this)[0].SetCollEff    ( 0.90, MCalibrationCam::kUV    );
  (*this)[0].SetCollEff    ( 0.90, MCalibrationCam::kCT1   );

  (*this)[0].SetCollEffErr ( 0.05,   MCalibrationCam::kGREEN );
  (*this)[0].SetCollEffErr ( 0.05,   MCalibrationCam::kBLUE  );
  (*this)[0].SetCollEffErr ( 0.05,   MCalibrationCam::kUV    );
  (*this)[0].SetCollEffErr ( 0.05,   MCalibrationCam::kCT1   );
  
  
}

// --------------------------------------------------------------------------
//
// One blind pixel with very well known attenuation 0.01 (datasheet delivered 
// with filter, precision better than 1%
//
void MCalibrationChargeBlindCamOneOldStyle::CreateAtts() 
{

  (*this)[0].SetAtt    ( 1.97, MCalibrationCam::kGREEN );
  (*this)[0].SetAtt    ( 1.96, MCalibrationCam::kBLUE  );
  (*this)[0].SetAtt    ( 1.95, MCalibrationCam::kUV    );
  (*this)[0].SetAtt    ( 1.95, MCalibrationCam::kCT1   );

  (*this)[0].SetAttErr ( 0.01,   MCalibrationCam::kGREEN );
  (*this)[0].SetAttErr ( 0.01,   MCalibrationCam::kBLUE  );
  (*this)[0].SetAttErr ( 0.01,   MCalibrationCam::kUV    );
  (*this)[0].SetAttErr ( 0.01,   MCalibrationCam::kCT1   );
  
}

