#ifndef MARS_MCalibrationIntensityChargeCam
#define MARS_MCalibrationIntensityChargeCam

#ifndef MARS_MCalibrationIntensityCam
#include "MCalibrationIntensityCam.h"
#endif

#ifndef MARS_MCalibrationChargeCam
#include "MCalibrationChargeCam.h"
#endif

class MCalibrationIntensityChargeCam : public MCalibrationIntensityCam
{
public:

  MCalibrationIntensityChargeCam(const char *name=NULL, const char *title=NULL);

  void InitSize( const UInt_t n );  

  // Setters   
  void  SetFFactorMethodValid           ( const Bool_t  b=kTRUE ) {
    ((MCalibrationChargeCam*)GetCam())->SetFFactorMethodValid(b); }
  void  SetNumPhotonsBlindPixelMethod   ( const Float_t f )  {
    ((MCalibrationChargeCam*)GetCam())->SetNumPhotonsBlindPixelMethod(f); } 
  void  SetNumPhotonsFFactorMethod      ( const Float_t f )  {
    ((MCalibrationChargeCam*)GetCam())->SetNumPhotonsFFactorMethod   (f); }      
  void  SetNumPhotonsPINDiodeMethod     ( const Float_t f )  {
    ((MCalibrationChargeCam*)GetCam())->SetNumPhotonsPINDiodeMethod  (f); }   
  void  SetNumPhotonsBlindPixelMethodErr( const Float_t f )  {
    ((MCalibrationChargeCam*)GetCam())->SetNumPhotonsBlindPixelMethodErr(f); } 
  void  SetNumPhotonsFFactorMethodErr   ( const Float_t f )  {
    ((MCalibrationChargeCam*)GetCam())->SetNumPhotonsFFactorMethodErr(f); }      
  void  SetNumPhotonsPINDiodeMethodErr  ( const Float_t f )  {
    ((MCalibrationChargeCam*)GetCam())->SetNumPhotonsPINDiodeMethodErr(f); }   
  
  ClassDef(MCalibrationIntensityChargeCam, 1) // Container Intensity Charge Calibration Results Camera
};

#endif
