#ifndef MARS_MCalibrationIntensityQECam
#define MARS_MCalibrationIntensityQECam

#ifndef MARS_MCalibrationIntensityCam
#include "MCalibrationIntensityCam.h"
#endif

#ifndef MARS_MCalibrationQECam
#include "MCalibrationQECam.h"
#endif

class MCalibrationIntensityQECam : public MCalibrationIntensityCam
{
public:

  MCalibrationIntensityQECam(const char *name=NULL, const char *title=NULL);

  void InitSize( const UInt_t n );  
  
  Float_t GetPlexiglassQE          () const {
    return ((MCalibrationQECam*)GetCam())->GetPlexiglassQE();  }    
  Float_t GetPlexiglassQERelVar    () const {
    return ((MCalibrationQECam*)GetCam())->GetPlexiglassQERelVar();  }

  Bool_t  IsBlindPixelMethodValid  () const {
    return ((MCalibrationQECam*)GetCam())->IsBlindPixelMethodValid();  }
  Bool_t  IsFFactorMethodValid     () const {
    return ((MCalibrationQECam*)GetCam())->IsFFactorMethodValid();  }
  Bool_t  IsCombinedMethodValid    () const {
    return ((MCalibrationQECam*)GetCam())->IsCombinedMethodValid();  }
  Bool_t  IsPINDiodeMethodValid    () const {
    return ((MCalibrationQECam*)GetCam())->IsPINDiodeMethodValid();  }
          
  Bool_t  IsBlindPixelMethodValid  ( MCalibrationCam::PulserColor_t col ) const {
    return ((MCalibrationQECam*)GetCam())->IsBlindPixelMethodValid(col);  }
  Bool_t  IsFFactorMethodValid     ( MCalibrationCam::PulserColor_t col ) const {
    return ((MCalibrationQECam*)GetCam())->IsFFactorMethodValid(col);  }
  Bool_t  IsCombinedMethodValid    ( MCalibrationCam::PulserColor_t col ) const {
    return ((MCalibrationQECam*)GetCam())->IsCombinedMethodValid(col);  }
  Bool_t  IsPINDiodeMethodValid    ( MCalibrationCam::PulserColor_t col ) const {
    return ((MCalibrationQECam*)GetCam())->IsPINDiodeMethodValid(col);  }

  void    SetBlindPixelMethodValid ( const Bool_t  b=kTRUE ) {
    ((MCalibrationQECam*)GetCam())->SetBlindPixelMethodValid(b);  }
  void    SetBlindPixelMethodValid ( const Bool_t  b, MCalibrationCam::PulserColor_t col) {
    ((MCalibrationQECam*)GetCam())->SetBlindPixelMethodValid(b,col);  }
  void    SetCombinedMethodValid   ( const Bool_t  b=kTRUE ) {
    ((MCalibrationQECam*)GetCam())->SetCombinedMethodValid(b);  }
  void    SetCombinedMethodValid   ( const Bool_t  b, MCalibrationCam::PulserColor_t col) {
    ((MCalibrationQECam*)GetCam())->SetCombinedMethodValid(b,col);  }
  void    SetFFactorMethodValid    ( const Bool_t  b=kTRUE ) {
    ((MCalibrationQECam*)GetCam())->SetFFactorMethodValid(b);  }
  void    SetFFactorMethodValid    ( const Bool_t  b, MCalibrationCam::PulserColor_t col) {
    ((MCalibrationQECam*)GetCam())->SetFFactorMethodValid(b,col);  }
  void    SetPINDiodeMethodValid   ( const Bool_t  b=kTRUE ) {
    ((MCalibrationQECam*)GetCam())->SetPINDiodeMethodValid(b);  }
  void    SetPINDiodeMethodValid   ( const Bool_t  b, MCalibrationCam::PulserColor_t col) {
    ((MCalibrationQECam*)GetCam())->SetPINDiodeMethodValid(b,col);  }

  ClassDef(MCalibrationIntensityQECam, 1) // Container Intensity Rel.Times Calibration Results Camera
};

#endif
