#ifndef MGDATACHECKMAIN_H
#define MGDATACHECKMAIN_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef ROOT_TGFrame
#include <TGFrame.h>
#endif

#ifndef MVIEWADCSPECTRA_H
#include "MViewAdcSpectra.h"
#endif

class TGMenuBar;
class TGPopupMenu;
class TGTab;
class TGTextButton;
class TGListBox;
class TGPictureButton;
class TGFileContainer;
class TGListView;

class MGDataCheckMain : public TGTransientFrame {
 private:
  
  //
  // Create a main frame with a number of different buttons.
  //

  //   some member not connected with Gui 
  
  Char_t            fInputFile[256] ; 
  MViewAdcSpectra   fViewAdc ; 

  //  the things for the menu bar 
    
  TGMenuBar         *fMenuBar ; 
  TGPopupMenu       *fFileMenu ;

  //   divide the Window in two different parts
  
  TGCompositeFrame  *fFrameTop ;   // top part of the main window
  TGCompositeFrame  *fFrameLow ;   // low part of the main window
  TGTab             *fTab      ;   // different tabs in the low window
  
  //     the horizontal frame in the top part

  TGHorizontalFrame *fTop1, *fTop2, *fTop3 ; 
  
  //   the buttons in the Top Part
  
  TGTextButton      *fButPedADC, *fButCrADC  ; 
  TGTextButton      *fButPedTDC, *fButCrTDC  ; 
  
  //   the things in the file selector

  TGCompositeFrame  *fTabF1 ;                       // first tab of low part 
  TGCompositeFrame  *fTabF1a, *fTabF1b ;            // subpart of the file selector in low window
  TGListBox         *fDir ; 
  TGPictureButton   *fCdup, *fListMode, *fDetail ; 
  TGFileContainer   *fFileCont ; 
  TGListView        *fFileView ;

  //     Layout hints for different uses 
  
  TGLayoutHints     *fLayMenuBar, *fLayMenuItem ; 
  TGLayoutHints     *fLayTab ; 
  
  //     some icons and pictures often used
  
  const TGPicture   *fPicCdup;   //!
  const TGPicture   *fPicList;   //!
  const TGPicture   *fPicDetail; //!
  
 public: 
  MGDataCheckMain(const TGWindow *p, const TGWindow *main, UInt_t w, UInt_t h) ;
  
  ~MGDataCheckMain(); 
  
  void   CloseWindow()  ; 

  Bool_t InputFileSelected() ; 
  
  Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);

  ClassDef(MGDataCheckMain, 1)

} ; 

#endif


