/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.

! *
!
!
!   Author(s): Markus Gaug   02/2004 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                               
// MCalibrationQECamMagic                                               
//                                                               
// Storage container for the calibrated Quantum Efficiency of the whole camera
// with Corning Blue and Corning Red values initialized for the MAGIC camera.
// The values are valid for the camera after July 5, 2004.
//
// The following plots display the distributions of the cornings: 
// * The corning blue w.r.t. the pixel index:
//   One can see the selection of pixels such that the highest corning blue values 
//   are located towards the center of the camera.
// * The corning red w.r.t. the pixel index:
//   One can see that there is a population in the outmost ring of inner pixels
//   with much lower corning reds. This characteristic is also valid for the 
//   quantum efficiency in the green. 
// * The corning blue vs. the corning red for the inner and outer pixels,
//   respectively. The two populations are clearly visible for the inner pixels, 
//   while for the outer ones, there is only one population with a bigger spread.
//   The blue line marks the distinction of the two populations as used in 
//   MCalibrationChargeCalc.
//
//Begin_Html
/*
<img src="images/Cornings.gif">
*/
//End_Html
//
// See also: MCalibrationQECam, MCalibrationQEPix, MCalibrationChargeCalc
//
/////////////////////////////////////////////////////////////////////////////
#include "MCalibrationQECamMagic.h"
#include "MCalibrationQECam.h"

ClassImp(MCalibrationQECamMagic);

using namespace std;

// --------------------------------------------------------------------------
//
// Default constructor. 
//
MCalibrationQECamMagic::MCalibrationQECamMagic(const char *name, const char *title)
    : MCalibrationQECam(name,title)
{
  
  CreateCorningReds();
  CreateCorningBlues();

}

void MCalibrationQECamMagic::CreateCorningReds()
{
  
  Double_t creds[577];
  
  creds[1] = 1.6;
  creds[2] = 8.7;
  creds[3] = 6.8;
  creds[4] = 10.3;
  creds[5] = 8.7;
  creds[6] = -1.;
  creds[7] = 1.3;
  creds[8] = 0.4;
  creds[9] = 7.7 ;
  creds[10] = 9.8;
  creds[11] = 5.9;
  creds[12] = 7.4;
  creds[13] = 7.4;
  creds[14] = 7.0;
  creds[15] = 7.2;
  creds[16] = 6.8;
  creds[17] = 6.9;
  creds[18] = 6.6;
  creds[19] = 1.8;
  creds[20] = 4.9;
  creds[21] = 7.1;
  creds[22] = 7.7;
  creds[23] = 8.9;
  creds[24] = 11.9;
  creds[25] = 1.6;
  creds[26] = 9.3;
  creds[27] = 5.8;
  creds[28] = 9.0;
  creds[29] = 6.5;
  creds[30] = 6.1;
  creds[31] = 8.1;
  creds[32] = 6.7;
  creds[33] = 7.0;
  creds[34] = 7.1;
  creds[35] = 7.8;
  creds[36] = 6.9;
  creds[37] = 0.9;
  creds[38] = 3.3;
  creds[39] = 7.1;
  creds[40] = 5.8;
  creds[41] = 4.4;
  creds[42] = 8.1;
  creds[43] = 6.0;
  creds[44] = 6.3;
  creds[45] = 6.0;
  creds[46] = 8.0;
  creds[47] = 0.6;
  creds[48] = 7.2;
  creds[49] = 5.6;
  creds[50] = 7.3;
  creds[51] = 8.0;
  creds[52] = 9.1;
  creds[53] = 1.4;
  creds[54] = 6.9;
  creds[55] = 9.1;
  creds[56] = 6.4;
  creds[57] = 6.1;
  creds[58] = 6.2;
  creds[59] = 7.7;
  creds[60] = 5.1;
  creds[61] = 7.9;
  creds[62] = 6.9;
  creds[63] = 3.3;
  creds[64] = 3.7;
  creds[65] = 5.8;
  creds[66] = 8.0;
  creds[67] = 7.3;
  creds[68] = 7.3;
  creds[69] = 9.1;
  creds[70] = 4.0;
  creds[71] = 8.2;
  creds[72] = 8.7;
  creds[73] = 9.1;
  creds[74] = 8.2;
  creds[75] = 9.0;
  creds[76] = 7.8;
  creds[77] = 7.5;
  creds[78] = 1.3;
  creds[79] = 6.9;
  creds[80] = 8.7;
  creds[81] = 7.6;
  creds[82] = 5.6;
  creds[83] = 10.4;
  creds[84] = 6.1;
  creds[85] = 0.9;
  creds[86] = 7.7;
  creds[87] = 7.4;
  creds[88] = 6.9;
  creds[89] = 7.0;
  creds[90] = 3.3;
  creds[91] = 7.1;
  creds[92] = 5.8;
  creds[93] = 7.2;
  creds[94] = 5.4;
  creds[95] = 7.4;
  creds[96] = 6.6;
  creds[97] = 0.0;
  creds[98] = 6.9;
  creds[99] = 7.3;
  creds[100] = 8.7;
  creds[101] = 6.5;
  creds[102] = 5.8;
  creds[103] = 6.1;
  creds[104] = 6.6;
  creds[105] = 8.7;
  creds[106] = 6.8;
  creds[107] = 7.0;
  creds[108] = 7.4;
  creds[109] = 7.1;
  creds[110] = 8.8;
  creds[111] = 7.0;
  creds[112] = 8.3;
  creds[113] = 3.5;
  creds[114] = 7.4;
  creds[115] = 8.7;
  creds[116] = 7.6;
  creds[117] = 7.6;
  creds[118] = 6.6;
  creds[119] = 5.9;
  creds[120] = 6.8;
  creds[121] = 0.4;
  creds[122] = 7.5;
  creds[123] = 5.7;
  creds[124] = 1.6;
  creds[125] = 6.2;
  creds[126] = 7.4;
  creds[127] = 7.3;
  creds[128] = 8.5;
  creds[129] = 6.9;
  creds[130] = 7.3;
  creds[131] = 6.8;
  creds[132] = 6.6;
  creds[133] = 6.5;
  creds[134] = 5.7;
  creds[135] = 5.8;
  creds[136] = 6.2;
  creds[137] = 5.8;
  creds[138] = 6.1;
  creds[139] = 7.2;
  creds[140] = 6.0;
  creds[141] = 7.7;
  creds[142] = 6.7;
  creds[143] = 4.3;
  creds[144] = 7.2;
  creds[145] = 7.0;
  creds[146] = 7.4;
  creds[147] = 5.4;
  creds[148] = 6.5;
  creds[149] = 5.9;
  creds[150] = 5.5;
  creds[151] = 7.0;
  creds[152] = 7.0;
  creds[153] = 6.5;
  creds[154] = 5.6;
  creds[155] = 5.6;
  creds[156] = 7.8;
  creds[157] = -1.;
  creds[158] = 5.7;
  creds[159] = 5.9;
  creds[160] = 5.9;
  creds[161] = 5.8;
  creds[162] = 1.2;
  creds[163] = 7.9;
  creds[164] = 7.7;
  creds[165] = 9.5;
  creds[166] = 6.4;
  creds[167] = 6.6;
  creds[168] = 7.1;
  creds[169] = 6.3;
  creds[170] = 7.4;
  creds[171] = 4.0;
  creds[172] = 6.2;
  creds[173] = 6.4;
  creds[174] = 3.8;
  creds[175] = 7.5;
  creds[176] = 8.0;
  creds[177] = 7.0;
  creds[178] = 6.0;
  creds[179] = 6.5;
  creds[180] = 7.1;
  creds[181] = 4.7;
  creds[182] = 9.7;
  creds[183] = 6.1;
  creds[184] = 6.7;
  creds[185] = 6.2;
  creds[186] = 6.7;
  creds[187] = 6.1;
  creds[188] = 4.9;
  creds[189] = 5.8;
  creds[190] = 6.4;
  creds[191] = 6.5;
  creds[192] = 7.1;
  creds[193] = 8.1;
  creds[194] = 5.5;
  creds[195] = 7.1;
  creds[196] = 6.5;
  creds[197] = 6.7;
  creds[198] = 7.0;
  creds[199] = 7.5;
  creds[200] = 6.5;
  creds[201] = 6.5;
  creds[202] = 6.8;
  creds[203] = 5.6;
  creds[204] = 6.9;
  creds[205] = 6.6;
  creds[206] = 7.4;
  creds[207] = 6.1;
  creds[208] = 6.8;
  creds[209] = 8.1;
  creds[210] = 7.6;
  creds[211] = 6.2;
  creds[212] = 6.9;
  creds[213] = 5.8;
  creds[214] = 7.0;
  creds[215] = 5.7;
  creds[216] = 4.1;
  creds[217] = 2.4;
  creds[218] = 1.1;
  creds[219] = 6.5;
  creds[220] = 5.9;
  creds[221] = 6.4;
  creds[222] = 7.3;
  creds[223] = 7.5;
  creds[224] = 1.2;
  creds[225] = 4.2;
  creds[226] = 6.4;
  creds[227] = 6.9;
  creds[228] = 7.1;
  creds[229] = 4.4;
  creds[230] = 7.4;
  creds[231] = 6.9;
  creds[232] = 5.3;
  creds[233] = 2.0;
  creds[234] = 6.3;
  creds[235] = 7.6;
  creds[236] = 8.2;
  creds[237] = 9.1;
  creds[238] = 6.3;
  creds[239] = 5.9;
  creds[240] = 7.2;
  creds[241] = 5.4;
  creds[242] = 9.1;
  creds[243] = 5.3;
  creds[244] = 5.0;
  creds[245] = 7.2;
  creds[246] = 4.5;
  creds[247] = 5.3;
  creds[248] = 9.0;
  creds[249] = 5.9;
  creds[250] = 9.1;
  creds[251] = 7.4;
  creds[252] = 4.8;
  creds[253] = 5.5;
  creds[254] = 3.9;
  creds[255] = 7.1;
  creds[256] = 6.3;
  creds[257] = 4.3;
  creds[258] = 6.2;
  creds[259] = 5.1;
  creds[260] = -1.;
  creds[261] = 1.2;
  creds[262] = 7.8;
  creds[263] = 0.4;
  creds[264] = 5.7;
  creds[265] = 4.2;
  creds[266] = 7.8;
  creds[267] = 8.6;
  creds[268] = 4.2;
  creds[269] = 6.7;
  creds[270] = 6.7;
  creds[271] = 5.2;
  creds[272] = 7.1;
  creds[273] = 0.2;
  creds[274] = 1.2;
  creds[275] = 6.0;
  creds[276] = 4.1;
  creds[277] = 0.9;
  creds[278] = 1.7;
  creds[279] = 6.8;
  creds[280] = 3.8;
  creds[281] = 1.8;
  creds[282] = 6.3;
  creds[283] = 4.1;
  creds[284] = 2.4;
  creds[285] = 7.2;
  creds[286] = 2.2;
  creds[287] = 6.6;
  creds[288] = 6.1;
  creds[289] = 2.6;
  creds[290] = 5.2;
  creds[291] = 1.4;
  creds[292] = 4.0;
  creds[293] = 2.6;
  creds[294] = 3.0;
  creds[295] = 6.6;
  creds[296] = 7.6;
  creds[297] = 5.6;
  creds[298] = 7.3;
  creds[299] = 7.3;
  creds[300] = 7.8;
  creds[301] = 1.5;
  creds[302] = 3.3;
  creds[303] = 0.6;
  creds[304] = 5.9;
  creds[305] = 7.0;
  creds[306] = 6.3;
  creds[307] = 3.9;
  creds[308] = 2.4;
  creds[309] = 5.8;
  creds[310] = 7.4;
  creds[311] = 1.5;
  creds[312] = 4.1;
  creds[313] = 4.5;
  creds[314] = 4.5;
  creds[315] = 6.6;
  creds[316] = 6.0;
  creds[317] = 6.0;
  creds[318] = 8.8;
  creds[319] = 5.6;
  creds[320] = 4.1;
  creds[321] = 4.6;
  creds[322] = 1.4;
  creds[323] = 2.1;
  creds[324] = 5.5;
  creds[325] = 3.4;
  creds[326] = 6.0;
  creds[327] = 3.6;
  creds[328] = 7.3;
  creds[329] = 6.4;
  creds[330] = 7.1;
  creds[331] = 8.1;
  creds[332] = 1.1;
  creds[333] = 2.8;
  creds[334] = 1.3;
  creds[335] = 1.6;
  creds[336] = 1.6;
  creds[337] = 1.6;
  creds[338] = 1.1;
  creds[339] = 1.3;
  creds[340] = 1.3;
  creds[341] = 1.2;
  creds[342] = 0.6;
  creds[343] = 8.0;
  creds[344] = 1.9;
  creds[345] = -1.;
  creds[346] = 2.4;
  creds[347] = 1.4;
  creds[348] = 6.1;
  creds[349] = 1.9;
  creds[350] = 1.6;
  creds[351] = 1.5;
  creds[352] = 1.0;
  creds[353] = 1.4;
  creds[354] = 1.3;
  creds[355] = 1.1;
  creds[356] = 1.1;
  creds[357] = 1.4;
  creds[358] = 1.8;
  creds[359] = 1.1;
  creds[360] = 1.6;
  creds[361] = 1.4;
  creds[362] = 1.4;
  creds[363] = 7.9;
  creds[364] = 2.0;
  creds[365] = 1.4;
  creds[366] = 7.6;
  creds[367] = 1.1;
  creds[368] = 1.4;
  creds[369] = 1.3;
  creds[370] = 0.8;
  creds[371] = 3.4;
  creds[372] = 0.9;
  creds[373] = 6.2;
  creds[374] = 0.4;
  creds[375] = 1.1;
  creds[376] = 1.4;
  creds[377] = 1.2;
  creds[378] = 1.4;
  creds[379] = 2.2;
  creds[380] = 2.0;
  creds[381] = 1.6;
  creds[382] = 2.2;
  creds[383] = 8.5;
  creds[384] = 1.9;
  creds[385] = 1.0;
  creds[386] = 1.8;
  creds[387] = 5.8;
  creds[388] = 1.1;
  creds[389] = 2.4;
  creds[390] = 2.4;
  creds[391] = 4.6;
  creds[392] = 1.2;
  creds[393] = -1.;
  creds[394] = 1.2;
  creds[395] = 0.6;
  creds[396] = 1.5;
  creds[397] = 1.0;
  creds[398] = 6.8;
  creds[399] = 17.4;
  creds[400] = 18.6;
  creds[401] = 2.3;
  creds[402] = 7.7;
  creds[403] = 2.2;
  creds[404] = 4.6;
  creds[405] = 4.0;
  creds[406] = 11.7;
  creds[407] = 5.0;
  creds[408] = 10.6;
  creds[409] = 17.7;
  creds[410] = 6.9;
  creds[411] = 6.3;
  creds[412] = 6.7;
  creds[413] = 1.9;
  creds[414] = 15.8;
  creds[415] = 4.9;
  creds[416] = 24.7;
  creds[417] = 12.0;
  creds[418] = 9.7;
  creds[419] = 19.3;
  creds[420] = 13.0;
  creds[421] = 1.6;
  creds[422] = 4.4;
  creds[423] = 2.8;
  creds[424] = 16.5;
  creds[425] = -1.;
  creds[426] = 8.1;
  creds[427] = 1.7;
  creds[428] = 6.2;
  creds[429] = 8.1;
  creds[430] = 14.5;
  creds[431] = 2.5;
  creds[432] = 12.9;
  creds[433] = 7.4;
  creds[434] = 7.9;
  creds[435] = 5.1;
  creds[436] = 6.5;
  creds[437] = 12.3;
  creds[438] = 8.4;
  creds[439] = 2.2;
  creds[440] = 5.0;
  creds[441] = 2.9;
  creds[442] = 10.4;
  creds[443] = 13.1;
  creds[444] = 5.6;
  creds[445] = 8.0;
  creds[446] = 5.9;
  creds[447] = 8.1;
  creds[448] = 6.8;
  creds[449] = 6.9;
  creds[450] = 12.3;
  creds[451] = 9.1;
  creds[452] = 2.7;
  creds[453] = 2.7;
  creds[454] = 4.2;
  creds[455] = 4.9;
  creds[456] = 10.9;
  creds[457] = 7.2;
  creds[458] = 18.3;
  creds[459] = 6.1;
  creds[460] = 7.7;
  creds[461] = 2.7;
  creds[462] = 17.6;
  creds[463] = 3.8;
  creds[464] = 12.6;
  creds[465] = 9.3;
  creds[466] = 9.2;
  creds[467] = 7.0;
  creds[468] = 7.9;
  creds[469] = 14.6;
  creds[470] = 13.6;
  creds[471] = 0.9;
  creds[472] = 8.1;
  creds[473] = 9.3;
  creds[474] = 3.0;
  creds[475] = 24.7;
  creds[476] = 19.5;
  creds[477] = 6.2;
  creds[478] = 6.9;
  creds[479] = 11.7;
  creds[480] = 11.3;
  creds[481] = 7.3;
  creds[482] = 12.8;
  creds[483] = 11.3;
  creds[484] = 3.9;
  creds[485] = 4.4;
  creds[486] = 5.9;
  creds[487] = 7.3;
  creds[488] = 7.1;
  creds[489] = 1.4;
  creds[490] = 12.6;
  creds[491] = 9.6;
  creds[492] = 10.7;
  creds[493] = 13.5;
  creds[494] = 1.9;
  creds[495] = 9.8;
  creds[496] = 5.6;
  creds[497] = 6.2;
  creds[498] = 14.0;
  creds[499] = 5.4;
  creds[500] = 8.4;
  creds[501] = 16.2;
  creds[502] = 15.1;
  creds[503] = 9.7;
  creds[504] = 13.0;
  creds[505] = 12.3;
  creds[506] = 7.4;
  creds[507] = -1.;
  creds[508] = 7.2;
  creds[509] = 9.6;
  creds[510] = 21.1;
  creds[511] = 2.3;
  creds[512] = 13.5;
  creds[513] = 14.3;
  creds[514] = 3.5;
  creds[515] = 6.7;
  creds[516] = -1.;
  creds[517] = 6.2;
  creds[518] = 8.3;
  creds[519] = 6.3;
  creds[520] = 5.8;
  creds[521] = 4.6;
  creds[522] = 1.8;
  creds[523] = 6.2;
  creds[524] = 11.;
  creds[525] = 1.8;
  creds[526] = 5.4;
  creds[527] = -1.;
  creds[528] = 12.9;
  creds[529] = 4.3;
  creds[530] = 15.5;
  creds[531] = -1.;
  creds[532] = 3.2;
  creds[533] = 9.9;
  creds[534] = 4.8;
  creds[535] = 8.0;
  creds[536] = 9.9;
  creds[537] = 4.4;
  creds[538] = 5.6;
  creds[539] = 13.5;
  creds[540] = 11.7;
  creds[541] = 18.7;
  creds[542] = 6.5;
  creds[543] = 11.7;
  creds[544] = 12.7;
  creds[545] = -1.;
  creds[546] = 7.3;
  creds[547] = 14.9;
  creds[548] = 6.8;
  creds[549] = 4.8;
  creds[550] = 7.1;
  creds[551] = 6.2;
  creds[552] = 2.3;
  creds[553] = 16.9;
  creds[554] = -1.;
  creds[555] = 14.6;
  creds[556] = 20.5;
  creds[557] = 7.0;
  creds[558] = 5.7;
  creds[559] = 6.6;
  creds[560] = 13.5;
  creds[561] = 11.0;
  creds[562] = 4.2;
  creds[563] = 10.6;
  creds[564] = 6.5;
  creds[565] = 6.5;
  creds[566] = 1.7;
  creds[567] = 8.2;
  creds[568] = 5.1;
  creds[569] = 5.6;
  creds[570] = 9.1;
  creds[571] = 0.6;
  creds[572] = 19.1;
  creds[573] = 5.7;
  creds[574] = 6.0;
  creds[575] = 3.9;
  creds[576] = 2.6;

  fCorningReds.Set(577,creds);
}

void MCalibrationQECamMagic::CreateCorningBlues()
{
 
  Double_t cblues[577];

  cblues[1] = 12.0;
  cblues[2] = 12.2;
  cblues[3] = 12.6;
  cblues[4] = 12.7;
  cblues[5] = 12.8;
  cblues[6] = -1.;
  cblues[7] = 10.8;
  cblues[8] = 9.0;
  cblues[9] = 12.2;
  cblues[10] = 12.3;
  cblues[11] = 11.7;
  cblues[12] = 12.0;
  cblues[13] = 12.1;
  cblues[14] = 12.0;
  cblues[15] = 12.6;
  cblues[16] = 12.2;
  cblues[17] = 12.6;
  cblues[18] = 12.6;
  cblues[19] = 11.5;
  cblues[20] = 11.1;
  cblues[21] = 11.2;
  cblues[22] = 12.1;
  cblues[23] = 12.8;
  cblues[24] = 12.7;
  cblues[25] = 12.8;
  cblues[26] = 13.0;
  cblues[27] = 13.0;
  cblues[28] = 12.0;
  cblues[29] = 12.4;
  cblues[30] = 12.0;
  cblues[31] = 12.1;
  cblues[32] = 12.0;
  cblues[33] = 12.2;
  cblues[34] = 12.0;
  cblues[35] = 12.5;
  cblues[36] = 12.4;
  cblues[37] = 10.3;
  cblues[38] = 10.8;
  cblues[39] = 11.4;
  cblues[40] = 11.7;
  cblues[41] = 12.1;
  cblues[42] = 12.0;
  cblues[43] = 12.4;
  cblues[44] = 13.0;
  cblues[45] = 12.7;
  cblues[46] = 12.8;
  cblues[47] = 10.5;
  cblues[48] = 12.1;
  cblues[49] = 12.1;
  cblues[50] = 12.4;
  cblues[51] = 12.3;
  cblues[52] = 12.4;
  cblues[53] = 11.7;
  cblues[54] = 12.8;
  cblues[55] = 12.0;
  cblues[56] = 12.5;
  cblues[57] = 12.2;
  cblues[58] = 12.3;
  cblues[59] = 12.3;
  cblues[60] = 12.6;
  cblues[61] = 11.6;
  cblues[62] = 11.9;
  cblues[63] = 11.8;
  cblues[64] = 10.7;
  cblues[65] = 10.9;
  cblues[66] = 12.1;
  cblues[67] = 12.5;
  cblues[68] = 12.4;
  cblues[69] = 12.1;
  cblues[70] = 12.2;
  cblues[71] = 13.1;
  cblues[72] = 12.5;
  cblues[73] = 12.4;
  cblues[74] = 12.6;
  cblues[75] = 12.5;
  cblues[76] = 12.1;
  cblues[77] = 12.5;
  cblues[78] = 12.3;
  cblues[79] = 12.0;
  cblues[80] = 12.4;
  cblues[81] = 12.4;
  cblues[82] = 12.0;
  cblues[83] = 12.3;
  cblues[84] = 12.1;
  cblues[85] = 11.3;
  cblues[86] = 12.0;
  cblues[87] = 12.0;
  cblues[88] = 12.4;
  cblues[89] = 12.3;
  cblues[90] = 12.0;
  cblues[91] = 11.4;
  cblues[92] = 11.7;
  cblues[93] = 11.9;
  cblues[94] = 11.4;
  cblues[95] = 11.1;
  cblues[96] = 11.9;
  cblues[97] = 9.2;
  cblues[98] = 12.4;
  cblues[99] = 11.5;
  cblues[100] = 12.3;
  cblues[101] = 11.0;
  cblues[102] = 12.0;
  cblues[103] = 11.8;
  cblues[104] = 12.5;
  cblues[105] = 11.6;
  cblues[106] = 12.3;
  cblues[107] = 11.2;
  cblues[108] = 12.4;
  cblues[109] = 11.5;
  cblues[110] = 12.1;
  cblues[111] = 11.0;
  cblues[112] = 12.1;
  cblues[113] = 11.6;
  cblues[114] = 12.0;
  cblues[115] = 11.4;
  cblues[116] = 12.0;
  cblues[117] = 11.7;
  cblues[118] = 12.6;
  cblues[119] = 11.4;
  cblues[120] = 12.3;
  cblues[121] = 10.9;
  cblues[122] = 12.1;
  cblues[123] = 11.8;
  cblues[124] = 12.2;
  cblues[125] = 11.5;
  cblues[126] = 12.1;
  cblues[127] = 11.7;
  cblues[128] = 11.4;
  cblues[129] = 11.5;
  cblues[130] = 11.2;
  cblues[131] = 11.8;
  cblues[132] = 11.3;
  cblues[133] = 11.5;
  cblues[134] = 11.1;
  cblues[135] = 11.7;
  cblues[136] = 11.2;
  cblues[137] = 11.6;
  cblues[138] = 11.8;
  cblues[139] = 11.4;
  cblues[140] = 11.6;
  cblues[141] = 11.1;
  cblues[142] = 11.9;
  cblues[143] = 11.4;
  cblues[144] = 11.5;
  cblues[145] = 11.6;
  cblues[146] = 11.9;
  cblues[147] = 11.0;
  cblues[148] = 11.6;
  cblues[149] = 11.9;
  cblues[150] = 11.5;
  cblues[151] = 11.8;
  cblues[152] = 11.4;
  cblues[153] = 11.9;
  cblues[154] = 11.0;
  cblues[155] = 11.7;
  cblues[156] = 11.9;
  cblues[157] = -1.;
  cblues[158] = 11.4;
  cblues[159] = 11.0;
  cblues[160] = 11.9;
  cblues[161] = 11.6;
  cblues[162] = 11.4;
  cblues[163] = 11.6;
  cblues[164] = 11.0;
  cblues[165] = 11.6;
  cblues[166] = 11.4;
  cblues[167] = 11.5;
  cblues[168] = 11.9;
  cblues[169] = 10.9;
  cblues[170] = 10.8;
  cblues[171] = 10.3;
  cblues[172] = 10.9;
  cblues[173] = 11.4;
  cblues[174] = 11.5;
  cblues[175] = 11.7;
  cblues[176] = 11.9;
  cblues[177] = 11.6;
  cblues[178] = 10.4;
  cblues[179] = 11.6;
  cblues[180] = 11.5;
  cblues[181] = 11.7;
  cblues[182] = 11.6;
  cblues[183] = 11.7;
  cblues[184] = 11.5;
  cblues[185] = 11.7;
  cblues[186] = 11.6;
  cblues[187] = 11.3;
  cblues[188] = 11.3;
  cblues[189] = 11.2;
  cblues[190] = 11.5;
  cblues[191] = 11.7;
  cblues[192] = 11.8;
  cblues[193] = 11.2;
  cblues[194] = 11.9;
  cblues[195] = 11.3;
  cblues[196] = 11.2;
  cblues[197] = 11.0;
  cblues[198] = 11.4;
  cblues[199] = 11.5;
  cblues[200] = 11.5;
  cblues[201] = 11.7;
  cblues[202] = 11.6;
  cblues[203] = 11.7;
  cblues[204] = 11.4;
  cblues[205] = 11.6;
  cblues[206] = 11.3;
  cblues[207] = 11.5;
  cblues[208] = 11.8;
  cblues[209] = 11.6;
  cblues[210] = 11.9;
  cblues[211] = 11.2;
  cblues[212] = 11.1;
  cblues[213] = 11.4;
  cblues[214] = 11.6;
  cblues[215] = 11.3;
  cblues[216] = 11.5;
  cblues[217] = 10.1;
  cblues[218] = 9.5;
  cblues[219] = 10.0;
  cblues[220] = 10.8;
  cblues[221] = 10.4;
  cblues[222] = 10.4;
  cblues[223] = 10.3;
  cblues[224] = 11.8;
  cblues[225] = 10.4;
  cblues[226] = 11.5;
  cblues[227] = 10.3;
  cblues[228] = 10.3;
  cblues[229] = 10.6;
  cblues[230] = 10.8;
  cblues[231] = 10.6;
  cblues[232] = 10.5;
  cblues[233] = 10.5;
  cblues[234] = 11.3;
  cblues[235] = 11.7;
  cblues[236] = 10.9;
  cblues[237] = 10.6;
  cblues[238] = 10.8;
  cblues[239] = 10.7;
  cblues[240] = 10.9;
  cblues[241] = 10.5;
  cblues[242] = 10.8;
  cblues[243] = 11.1;
  cblues[244] = 11.2;
  cblues[245] = 10.6;
  cblues[246] = 10.6;
  cblues[247] = 10.9;
  cblues[248] = 10.6;
  cblues[249] = 10.3;
  cblues[250] = 10.6;
  cblues[251] = 10.7;
  cblues[252] = 11.5;
  cblues[253] = 11.8;
  cblues[254] = 10.8;
  cblues[255] = 10.4;
  cblues[256] = 10.6;
  cblues[257] = 10.6;
  cblues[258] = 10.5;
  cblues[259] = 10.3;
  cblues[260] = -1.;
  cblues[261] = 11.1;
  cblues[262] = 10.7;
  cblues[263] = 10.6;
  cblues[264] = 10.5;
  cblues[265] = 10.7;
  cblues[266] = 10.3;
  cblues[267] = 10.2;
  cblues[268] = 10.4;
  cblues[269] = 10.2;
  cblues[270] = 11.4;
  cblues[271] = 10.9;
  cblues[272] = 11.5;
  cblues[273] = 8.9;
  cblues[274] = 8.3;
  cblues[275] = 8.9;
  cblues[276] = 13.7;
  cblues[277] = 8.4;
  cblues[278] = 9.6;
  cblues[279] = 10.0;
  cblues[280] = 9.0;
  cblues[281] = 12.2;
  cblues[282] = 9.9;
  cblues[283] = 9.0;
  cblues[284] = 10.0;
  cblues[285] = 10.1;
  cblues[286] = 9.5;
  cblues[287] = 10.0;
  cblues[288] = 10.8;
  cblues[289] = 10.8;
  cblues[290] = 10.3;
  cblues[291] = 11.6;
  cblues[292] = 9.8;
  cblues[293] = 10.1;
  cblues[294] = 9.8;
  cblues[295] = 9.6;
  cblues[296] = 9.2;
  cblues[297] = 9.7;
  cblues[298] = 10.2;
  cblues[299] = 10.2;
  cblues[300] = 10.9;
  cblues[301] = 12.1;
  cblues[302] = 10.0;
  cblues[303] = 9.8;
  cblues[304] = 9.6;
  cblues[305] = 10.9;
  cblues[306] = 10.3;
  cblues[307] = 10.2;
  cblues[308] = 9.4;
  cblues[309] = 9.8;
  cblues[310] = 10.8;
  cblues[311] = 12.3;
  cblues[312] = 9.6;
  cblues[313] = 9.5;
  cblues[314] = 9.0;
  cblues[315] = 10.3;
  cblues[316] = 10.4;
  cblues[317] = 10.9;
  cblues[318] = 9.9;
  cblues[319] = 10.0;
  cblues[320] = 10.1;
  cblues[321] = 8.1;
  cblues[322] = 12.1;
  cblues[323] = 10.1;
  cblues[324] = 10.1;
  cblues[325] = 9.3;
  cblues[326] = 10.1;
  cblues[327] = 9.4;
  cblues[328] = 9.6;
  cblues[329] = 10.6;
  cblues[330] = 10.7;
  cblues[331] = 10.2;
  cblues[332] = 11.5;
  cblues[333] = 11.9;
  cblues[334] = 11.9;
  cblues[335] = 11.8;
  cblues[336] = 13.1;
  cblues[337] = 10.9;
  cblues[338] = 10.4;
  cblues[339] = 11.7;
  cblues[340] = 11.5;
  cblues[341] = 10.6;
  cblues[342] = 9.5;
  cblues[343] = 11.5;
  cblues[344] = 11.9;
  cblues[345] = -1.;
  cblues[346] = 10.3;
  cblues[347] = 8.0;
  cblues[348] = 11.0;
  cblues[349] = 12.1;
  cblues[350] = 12.0;
  cblues[351] = 12.1;
  cblues[352] = 11.2;
  cblues[353] = 11.2;
  cblues[354] = 12.4;
  cblues[355] = 11.0;
  cblues[356] = 11.6;
  cblues[357] = 11.4;
  cblues[358] = 10.6;
  cblues[359] = 11.0;
  cblues[360] = 11.8;
  cblues[361] = 12.4;
  cblues[362] = 12.4;
  cblues[363] = 12.2;
  cblues[364] = 9.8;
  cblues[365] = 11.7;
  cblues[366] = 9.8;
  cblues[367] = 11.4;
  cblues[368] = 12.0;
  cblues[369] = 11.7;
  cblues[370] = 10.9;
  cblues[371] = 11.2;
  cblues[372] = 10.6;
  cblues[373] = 10.0;
  cblues[374] = 10.0;
  cblues[375] = 10.6;
  cblues[376] = 11.2;
  cblues[377] = 12.0;
  cblues[378] = 11.3;
  cblues[379] = 12.5;
  cblues[380] = 12.0;
  cblues[381] = 11.4;
  cblues[382] = 12.0;
  cblues[383] = 13.6;
  cblues[384] = 12.6;
  cblues[385] = 10.9;
  cblues[386] = 12.0;
  cblues[387] = 10.0;
  cblues[388] = 11.4;
  cblues[389] = 11.6;
  cblues[390] = 10.3;
  cblues[391] = 8.5;
  cblues[392] = 11.7;
  cblues[393] = -1.;
  cblues[394] = 12.1;
  cblues[395] = 10.5;
  cblues[396] = 12.1;
  cblues[397] = 9.5;
  cblues[398] = 9.9;
  cblues[399] = 12.9;
  cblues[400] = 12.4;
  cblues[401] = 11.3;
  cblues[402] = 10.8;
  cblues[403] = 11.2;
  cblues[404] = 9.2;
  cblues[405] = 10.7;
  cblues[406] = 13.6;
  cblues[407] = 11.6;
  cblues[408] = 11.2;
  cblues[409] = 11.1;
  cblues[410] = 11.6;
  cblues[411] = 10.4;
  cblues[412] = 12.0;
  cblues[413] = 12.0;
  cblues[414] = 10.6;
  cblues[415] = 11.2;
  cblues[416] = 11.6;
  cblues[417] = 10.2;
  cblues[418] = 11.3;
  cblues[419] = 9.1;
  cblues[420] = 11.6;
  cblues[421] = 11.0;
  cblues[422] = 10.6;
  cblues[423] = 12.5;
  cblues[424] = 12.0;
  cblues[425] = -1.;
  cblues[426] = 11.5;
  cblues[427] = 11.2;
  cblues[428] = 10.2;
  cblues[429] = 11.8;
  cblues[430] = 10.8;
  cblues[431] = 11.1;
  cblues[432] = 11.0;
  cblues[433] = 11.5;
  cblues[434] = 11.9;
  cblues[435] = 9.5;
  cblues[436] = 11.3;
  cblues[437] = 11.2;
  cblues[438] = 11.4;
  cblues[439] = 10.1;
  cblues[440] = 11.0;
  cblues[441] = 10.8;
  cblues[442] = 9.3;
  cblues[443] = 12.6;
  cblues[444] = 9.9;
  cblues[445] = 9.8;
  cblues[446] = 10.4;
  cblues[447] = 11.3;
  cblues[448] = 12.0;
  cblues[449] = 11.0;
  cblues[450] = 11.7;
  cblues[451] = 12.0;
  cblues[452] = 9.1;
  cblues[453] = 11.2;
  cblues[454] = 10.6;
  cblues[455] = 12.3;
  cblues[456] = 10.9;
  cblues[457] = 9.7;
  cblues[458] = 11.2;
  cblues[459] = 12.2;
  cblues[460] = 12.5;
  cblues[461] = 9.0;
  cblues[462] = 11.6;
  cblues[463] = 11.3;
  cblues[464] = 10.8;
  cblues[465] = 10.7;
  cblues[466] = 12.1;
  cblues[467] = 11.9;
  cblues[468] = 12.2;
  cblues[469] = 11.6;
  cblues[470] = 11.5;
  cblues[471] = 10.3;
  cblues[472] = 11.8;
  cblues[473] = 10.7;
  cblues[474] = 10.4;
  cblues[475] = 11.9;
  cblues[476] = 11.2;
  cblues[477] = 10.7;
  cblues[478] = 10.4;
  cblues[479] = 10.4;
  cblues[480] = 11.3;
  cblues[481] = 11.6;
  cblues[482] = 10.1;
  cblues[483] = 9.4;
  cblues[484] = 12.3;
  cblues[485] = 11.2;
  cblues[486] = 9.6;
  cblues[487] = 10.5;
  cblues[488] = 11.7;
  cblues[489] = 10.5;
  cblues[490] = 11.5;
  cblues[491] = 10.4;
  cblues[492] = 12.1;
  cblues[493] = 13.0;
  cblues[494] = 10.9;
  cblues[495] = 11.0;
  cblues[496] = 11.0;
  cblues[497] = 12.5;
  cblues[498] = 12.3;
  cblues[499] = 12.8;
  cblues[500] = 12.2;
  cblues[501] = 10.6;
  cblues[502] = 11.6;
  cblues[503] = 11.6;
  cblues[504] = 11.6;
  cblues[505] = 10.9;
  cblues[506] = 11.9;
  cblues[507] = -1.;
  cblues[508] = 12.1;
  cblues[509] = 12.4;
  cblues[510] = 11.6;
  cblues[511] = 10.2;
  cblues[512] = 11.4;
  cblues[513] = 11.9;
  cblues[514] = 9.6;
  cblues[515] = 11.1;
  cblues[516] = -1.;
  cblues[517] = 9.7;
  cblues[518] = 12.4;
  cblues[519] = 9.6;
  cblues[520] = 10.6;
  cblues[521] = 10.3;
  cblues[522] = 11.1;
  cblues[523] = 10.7;
  cblues[524] = 13.3;
  cblues[525] = 9.7;
  cblues[526] = 10.8;
  cblues[527] = -1.;
  cblues[528] = 12.3;
  cblues[529] = 12.6;
  cblues[530] = 11.9;
  cblues[531] = -1.;
  cblues[532] = 10.2;
  cblues[533] = 11.0;
  cblues[534] = 10.8;
  cblues[535] = 9.8;
  cblues[536] = 11.6;
  cblues[537] = 10.8;
  cblues[538] = 9.9;
  cblues[539] = 12.4;
  cblues[540] = 10.4;
  cblues[541] = 11.6;
  cblues[542] = 11.1;
  cblues[543] = 10.5;
  cblues[544] = 11.1;
  cblues[545] = -1.;
  cblues[546] = 11.6;
  cblues[547] = 11.2;
  cblues[548] = 9.7;
  cblues[549] = 10.9;
  cblues[550] = 11.7;
  cblues[551] = 10.7;
  cblues[552] = 10.2;
  cblues[553] = 11.1;
  cblues[554] = -1.;
  cblues[555] = 11.8;
  cblues[556] = 12.2;
  cblues[557] = 10.5;
  cblues[558] = 11.2;
  cblues[559] = 10.1;
  cblues[560] = 12.3;
  cblues[561] = 11.6;
  cblues[562] = 9.9;
  cblues[563] = 10.5;
  cblues[564] = 11.3;
  cblues[565] = 11.8;
  cblues[566] = 10.7;
  cblues[567] = 11.1;
  cblues[568] = 11.8;
  cblues[569] = 10.5;
  cblues[570] = 11.8;
  cblues[571] = 9.6;
  cblues[572] = 11.1;
  cblues[573] = 11.0;
  cblues[574] = 11.8;
  cblues[575] = 11.4;
  cblues[576] = 10.2;

  fCorningBlues.Set(577,cblues);
}
