#ifndef MARS_MExtractTimeAndChargeDigitalFilter
#define MARS_MExtractTimeAndChargeDigitalFilter

#ifndef MARS_MExtractTimeAndCharge
#include "MExtractTimeAndCharge.h"
#endif

class MPedestalPix;
class MExtractTimeAndChargeDigitalFilter : public MExtractTimeAndCharge
{
private:

  static const Byte_t fgHiGainFirst;
  static const Byte_t fgHiGainLast;
  static const Byte_t fgLoGainFirst;
  static const Byte_t fgLoGainLast;
  static const Int_t  fgHiGainWindowSize;
  static const Int_t  fgLoGainWindowSize;
  static const Int_t  fgBinningResolution;
  
  Int_t   fWindowSizeHiGain;            
  Int_t   fWindowSizeLoGain;            

  Int_t   fBinningResolution;
  Int_t   fBinningResolutionHalf;
  
  Float_t fw_amp [60]; 
  Float_t fw_time[60];

  Int_t  ReadEnv(const TEnv &env, TString prefix, Bool_t print);
  
protected:

  virtual void FindTimeAndChargeHiGain(Byte_t *firstused, Byte_t *logain, Float_t &sum, Float_t &dsum,
                                       Float_t &time, Float_t &dtime,
                                       Byte_t &sat, const MPedestalPix &ped, const Bool_t abflag);
  virtual void FindTimeAndChargeLoGain(Byte_t *firstused, Float_t &sum,  Float_t &dsum,
                                       Float_t &time, Float_t &dtime,
                                       Byte_t &sat, const MPedestalPix &ped, const Bool_t abflag);

public:

  MExtractTimeAndChargeDigitalFilter(const char *name=NULL, const char *title=NULL);  

  void SetWeightsFile(TString filename="pulpo_weights.root");
  void SetWindowSize(Int_t windowh=fgHiGainWindowSize,
                     Int_t windowl=fgLoGainWindowSize);

  void SetBinningResolution(Int_t r=fgBinningResolution)  {
    fBinningResolution     = r & ~1;
    fBinningResolutionHalf = fBinningResolution/2; }
  
  
  ClassDef(MExtractTimeAndChargeDigitalFilter, 0)   // Hendrik's digital filter
};

#endif



