#ifndef MARS_MFSize
#define MARS_MFSize
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MFSize                                                           //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

#include <TH1F.h>

class MParList;
class MHillas;

class MFSize : public MFilter
{
private:
    Int_t fNumSelectedEvts; // counter for number of selected events

    MHillas *fHillas;       // Hillas parameters container
    TH1F* fProb;            // Acceptance probability vs log10 size

    Bool_t fResult;         // Result returned by IsExpressionTrue

    Int_t PreProcess(MParList *pList);
    Int_t Process();

public:
    MFSize(const char *name=NULL, const char *title=NULL);

    void SetProb(TH1F* h);

    Bool_t IsExpressionTrue() const { return fResult; }

    ClassDef(MFSize, 0) // A Filter to select events as a function of Size
};

#endif






