#ifndef MARS_MPedCalUpdate
#define MARS_MPedCalUpdate

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MPedPhotCam;
class MCalibrationChargeCam;
class MBadPixelsCam;

class MPedCalUpdate : public MTask
{
private:
    MPedPhotCam           *fPedPhot;
    MCalibrationChargeCam *fCalCam;
    MBadPixelsCam         *fBadPix;

    TString fFileName;

    Int_t fLast;

    Bool_t ReadCal(const char *name);
    Bool_t ReadPed(const char *name);
    Bool_t ReadPC(TString &line);
    Bool_t ReInit(MParList *pList);

public:
    MPedCalUpdate(const char *filename, const char *name=NULL, const char *title=NULL);

    ClassDef(MPedCalUpdate, 1) // Task to update Pedestals and Cal-Constants while an eventloop is running
}; 

#endif

