#ifndef __RFL_HEADER__
#define __RFL_HEADER__


/*  Event header of reflector files ver <= 0.5  */ 
typedef struct
{   float	EvtNumber;
    float	PrimaryID;
    float	Etotal;   
    float	Thick0;   
    float	FirstTarget;
    float	zFirstInt;
    float	p[3];     
    float	Theta; 
    float	Phi; 

    float	NumRndSeq;
    float	RndData[10][3];
  
    float	RunNumber;
    float	DateRun;
    float	Corsika_version;

    float	NumObsLev;  /* Should be 1 for MAGIC simulation */
    float	HeightLev;  /* Observation Level */

    /* Changed meaning of next 9 variables. June 2002, A.Moralejo: */
    float       num_mirrors;
    float       mean_reflectivity;
    float       longi_Nmax;
    float       longi_t0;
    float       longi_tmax;
    float       longi_a;
    float       longi_b;
    float       longi_c;
    float       longi_chi2;

    float	SlopeSpec;
    float	ELowLim;   
    float	EUppLim;   

    float	ThetaMin;
    float	ThetaMax;
    float	PhiMin;
    float	PhiMax;

    float	CWaveLower;       
    float	CWaveUpper;       
    float	CorePos[2][20];   
    float	TimeFirst;
    float	TimeLast;

    /* AM, 23/05/2002: Changed meaning of following
     * three variables (which were unused before): 
     */
    float	telescopePhi;    /* rad */
    float	telescopeTheta;  /* rad */
  
    float	ViewConeRadius; /* Degrees.
				 * Radius of "view cone" when the primaries'
				 * directions generated by Corsika lie within
				 * a cone around a fixed direction. This is
				 * only possible with Corsika>6 versions. In
				 * that case, PhiMin=PhiMax  and 
				 * ThetaMin=ThetaMax (also in this header) 
				 * indicate the axis of this cone.   
				 * If ViewConeRadius==0, it means that
				 * the VIEWCONE option was not used.
				 */


    float	CORSIKAPhs;	/*  Original photons written by Corsika	*/
    float	AtmAbsPhs;	/*  Photons absorbed by the atmosphere	*/
    float	MirrAbsPhs;	/*  Photons absorbed by the mirror	*/
    float	OutOfMirrPhs;	/*  Photons outside the mirror		*/
    float	BlackSpotPhs;	/*  Photons lost in the "black spot"	*/
    float	OutOfChamPhs;	/*  Photons outside the camera		*/
    float	CPhotons;	/*  Photons reaching the camera         */

}   RflEventHeader_old;


/* Reflector files run header (same as CORSIKA's cer files run header): */

typedef struct
{   char RUNH[4];
    float RunNumber;
    float date;
    float Corsika_version;
    float NumObsLev;
    float HeightLev[10];
    float SlopeSpec;  /* Slope of primaries' energy spectrum */
    float ELowLim;  
    float EUppLim;    /* Limits of energy range for generation */
    float EGS4_flag;
    float NKG_flag;
    float Ecutoffh;  
    float Ecutoffm;  
    float Ecutoffe;  
    float Ecutoffg;  
    /* Physical constants and interaction flags (see CORSIKA manual): */
    float C[50];
    float wobble_mode;
    float atmospheric_model;
    float dummy1[18]; /* not used */
    float CKA[40];
    float CETA[5];
    float CSTRBA[11];
    float dummy2[104]; /* not used */
    float AATM[5];
    float BATM[5];
    float CATM[5];
    float NFL[4];

}   RflRunHeader;


/*  Event header of reflector_0.6 files: */ 

typedef struct			
{   char	EVTH[4];
    float	EvtNumber;
    float	PrimaryID;
    float	Etotal;   
    float	Thick0;   
    float	FirstTarget;
    float	zFirstInt;
    float	p[3];     
    float	Theta; 
    float	Phi; 

    float	NumRndSeq;
    float	RndData[10][3];
  
    float	RunNumber;
    float	DateRun;
    float	Corsika_version;

    float	NumObsLev;
    float	HeightLev[10]; 

    float	SlopeSpec;
    float	ELowLim;   
    float	EUppLim;   

    float	Ecutoffh;  
    float	Ecutoffm;  
    float	Ecutoffe;  
    float	Ecutoffg;  

    float	NFLAIN;
    float	NFLDIF;
    float	NFLPI0;
    float	NFLPIF;
    float	NFLCHE;
    float	NFRAGM; 
 
    float	Bx;
    float	By;
  
    float	EGS4yn;
    float	NKGyn;
    float	GHEISHAyn;
    float	VENUSyn;
    float	CERENKOVyn;
    float	NEUTRINOyn;
    float	HORIZONTyn;
    float	COMPUTER;

    float	ThetaMin;
    float	ThetaMax;
    float	PhiMin;
    float	PhiMax;

    float	CBunchSize;
    float	CDetInX,CDetInY;
    float	CSpacInX,CSpacInY;
    float	CLenInX,CLenInY;
    float	COutput;

    float	AngleNorthX;
    float	MuonInfo;

    float	StepLength;
    float	CWaveLower;       
    float	CWaveUpper;       
    float	Multipl;       
    float	CorePos[2][20];   
    float       SIBYLL[2];
    float       QGSJET[2];
    float       DPMJET[2];
    float       VENUS_cross;
    float       mu_mult_scat;
    float       NKG_range;
    float       EFRCTHN[2];
    float       WMAX[2];
    float       rthin_rmax;

    float       viewcone_angles[2]; 
    /* (degrees) Inner and outer angles in 
     * Corsika's VIEWCONE option. This is
     * only possible with Corsika>6 versions. In
     * that case, PhiMin=PhiMax  and 
     * ThetaMin=ThetaMax (also in this header) 
     * indicate the axis of this cone.   
     */

    /* ^^^ Up to here, the info from the CORSIKA event header. */

    /* Telescope orientation: */
    float	telescopePhi;    /* rad */
    float	telescopeTheta;  /* rad */

    /* Time of first and last photon: */
    float	TimeFirst;
    float	TimeLast;

    /* 6 parameters and chi2 of the NKG fit to the longitudinal 
     * particle distribution (see CORSIKA manual for explanation): 
     */
    float       longi_Nmax;
    float       longi_t0;
    float       longi_tmax;
    float       longi_a;
    float       longi_b;
    float       longi_c;
    float       longi_chi2;

    /* Now the photon statistics of the event: */
    float	CORSIKAPhs;	/*  Original photons written by Corsika	*/
    float	AtmAbsPhs;	/*  Photons absorbed by the atmosphere	*/
    float	MirrAbsPhs;	/*  Photons absorbed by the mirror	*/
    float	OutOfMirrPhs;	/*  Photons outside the mirror		*/
    float	BlackSpotPhs;	/*  Photons lost in the "black spot"	*/
    float	OutOfChamPhs;	/*  Photons outside the camera		*/
    float	CPhotons;	/*  Photons reaching the camera         */
 
    /* Now follow the fraction of photons reaching the camera produced by
     * electrons, muons and other particles respectively: 
     */ 
    float       elec_cph_fraction;
    float       muon_cph_fraction;
    float       other_cph_fraction;

    float       dummy[7];      /* not used */
}   RflEventHeader;

/*Photons data estructure*/
typedef struct
{   float w,                    /*  cphoton wavelength (nm)             */
      x, y,			/*  (camera) imp. point (cm)            */
      u, v,			/*  direction cosines                   */
      t,			/*  arrival time (ns)                   */
      h,			/*  production height (cm)              */
      phi;			/*  (camera) inc. angle (rad)           */
    }   cphoton;

#endif




