#ifndef MARS_MTSupercutsApplied
#define MARS_MTSupercutsApplied
//////////////////////////////////////////////////////////////////////////
//                                                                      //
// MTSupercutsApplied                                                      //
//                                                                      //
// Class containing TTree object used to store 
// supercuts applied to all individual events                               //
//                                                                      //
//////////////////////////////////////////////////////////////////////////
#ifndef MARS_MAGIC
#include "MAGIC.h"
#endif

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif


#ifndef ROOT_TObject
#include <TObject.h>
#endif
#ifndef ROOT_TString
#include <TString.h>
#endif
#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif
#ifndef ROOT_TTree
#include <TTree.h>
#endif

class MTSupercutsApplied : public MParContainer
{
private:
    
    Int_t fNCutParameters;
    Int_t fNShowerParameters;

    Double_t* fCutParameters;
    Double_t* fShowerParameters;
/*
    Double_t fLengthUp;
    Double_t fLengthLow;
    Double_t fWidthUp;
    Double_t fWidthLow;
    Double_t fDistUp;
    Double_t fDistLow;    
*/
    TTree* fRootTree;

    Bool_t fBranchesCreated;

    TString fCutParamBranchName;
    TString fShowerParamBranchName;

    TString fCutParametersNamesTypes;
    TString fShowerParametersNamesTypes;

public:
    MTSupercutsApplied(const char* name=NULL, const char* title=NULL);
    ~MTSupercutsApplied();

    /*
    Double_t GetLengthUp() const { return fLengthUp; }
    Double_t GetLengthLow() const { return fLengthLow; }
    Double_t GetWidthUp() const { return fWidthUp; }
    Double_t GetWidthLow() const { return fWidthLow; }
    Double_t GetDistUp() const { return fDistUp; }
    Double_t GetDistLow() const { return fDistLow; }


    void     SetLengthUp(Double_t x) { fLengthUp = x; }
    void     SetLengthLow(Double_t x) { fLengthLow = x; }
    void     SetWidthUp(Double_t x) { fWidthUp = x; }
    void     SetWidthLow(Double_t x) { fWidthLow = x; }
    void     SetDistUp(Double_t x) { fDistUp = x; }
    void     SetDistLow(Double_t x) { fDistLow = x; }
    */
     
    Bool_t CreateTreeBranches();

    Bool_t FillTreeBranches(TArrayD CutParamVector, 
			    TArrayD ShowerParamVector);
    	
    TTree* GetTreePointer() {return fRootTree;}
    

    ClassDef(MTSupercutsApplied, 1) // Storage Container for the supercuts applied
};

#endif






