#ifndef MARS_MImgCleanStd
#define MARS_MImgCleanStd

#ifndef MARS_MGTask
#include "MGTask.h"
#endif

class MGeomCam;
class MSigmabar;
class MCerPhotPix;
class MCerPhotEvt;
class MPedPhotCam;
class MArrivalTime;
class MCameraData;

class MGGroupFrame;

class MImgCleanStd : public MGTask
{
public:
    typedef enum {
        kStandard,
        kScaled,
        kDemocratic,
        kProbability,
        kAbsolute
    } CleaningMethod_t;

private:
    static const TString gsNamePedPhotCam; // default name of the 'MPedPhotCam' container

    const MGeomCam     *fCam;  //!
          MCerPhotEvt  *fEvt;  //!
          MPedPhotCam  *fPed;  //!
          MArrivalTime *fTime; //!
          MCameraData  *fData; //!

    CleaningMethod_t fCleaningMethod;

    Float_t  fCleanLvl1;
    Float_t  fCleanLvl2;

    UShort_t fCleanRings;

    TString  fNamePedPhotCam; // name of the 'MPedPhotCam' container


    void  CreateGuiElements(MGGroupFrame *f);
    void  StreamPrimitive(ofstream &out) const;
    Int_t ReadEnv(const TEnv &env, TString prefix, Bool_t print);

    void  CleanStep3b(MCerPhotPix &pix);
    void  CleanStep4(UShort_t r, MCerPhotPix &pix);

    void  CleanStep1();
    void  CleanStep2();
    void  CleanStep3();

    Int_t PreProcess(MParList *pList);
    Int_t Process();

public:
    MImgCleanStd(const Float_t lvl1=3.0, const Float_t lvl2=2.5,
                 const char *name=NULL, const char *title=NULL);
    void Print(Option_t *o="") const;

    Float_t  GetCleanLvl1() const { return fCleanLvl1; }
    Float_t  GetCleanLvl2() const { return fCleanLvl2; }
    UShort_t GetCleanRings() const { return fCleanRings;}

    void SetCleanRings(UShort_t r) { if(r==0) r=1; fCleanRings=r; }
    void SetMethod(CleaningMethod_t m) { fCleaningMethod = m; }

    Bool_t ProcessMessage(Int_t msg, Int_t submsg, Long_t param1, Long_t param2);
    void SetNamePedPhotCam(const char *name)  { fNamePedPhotCam = name; }

    ClassDef(MImgCleanStd, 2)    // task doing the image cleaning
}; 

#endif
