#ifndef MARS_MGeomApply
#define MARS_MGeomApply

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MParList;

class MGeomApply : public MTask
{
private:
    TString fGeomName; // Name of geometry class

    Int_t  PreProcess(MParList *plist);
    Bool_t ReInit(MParList *pList);
    void   StreamPrimitive(ofstream &out) const;

public:
    MGeomApply(const char *name=NULL, const char *title=NULL);

    void SetGeometry(TString geom) { fGeomName = geom; }

    ClassDef(MGeomApply, 0) // Task to apply geometry settings
};
    
#endif

