#ifndef MARS_MRawEvtHeader
#define MARS_MRawEvtHeader

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef MARS_MCalibrationCam
#include "MCalibrationCam.h"
#endif

// gcc 3.2
//class ifstream;
#include <iosfwd>

class MTime;
class MArrayB;
class MRawRunHeader;

class MRawEvtHeader : public MParContainer
{
public:
    //
    // Trigger Type (TT)
    //
    enum {
        kTTEvent       = 0,
        kTTPedestal    = 1,
        kTTCalibration = 2,
        kTTPinDiode    = 3
    };

    enum CLColor_t 
      {
        kCLUV       = BIT(0),
        kCLGreen    = BIT(1),
        kCLAmber    = BIT(2),
        kCLRed      = BIT(3),
        kCLRedAmber   = kCLRed & kCLAmber,
        kCLRedGreen   = kCLRed & kCLGreen,
        kCLRedUV      = kCLRed & kCLUV   ,
        kCLAmberGreen = kCLAmber & kCLGreen,
        kCLAmberUV    = kCLAmber & kCLUV   ,
        kCLGreenUV    = kCLGreen & kCLUV   ,
        kCLRedAmberGreen = kCLRedAmber & kCLGreen,
        kCLRedGreenUV    = kCLRedGreen & kCLUV,
        kCLAmberGreenUV  = kCLAmberGreen & kCLUV,
        kCLAll           = kCLRedAmberGreen & kCLUV
      };
    
    enum PulserColorCode_t 
      {
        kSlot1Green     = BIT(0),
        kSlot2Green     = BIT(1),
        kSlot3Blue      = BIT(2),
        kSlot4UV        = BIT(3),
        kSlot5UV        = BIT(4),
        kSlot6Blue      = BIT(5),
        kSlot7Blue      = BIT(6),
        kSlot8Blue      = BIT(7),
        kSlot9AttBlue   = BIT(8),
        kSlot10Blue     = BIT(9),
        kSlot11Blue     = BIT(10),
        kSlot12UV       = BIT(11),
        kSlot13UV       = BIT(12),
        kSlot14Blue     = BIT(13),
        kSlot15Green    = BIT(14),
        kSlot16AttGreen = BIT(15),
        kCT1Pulser      = BIT(16),
        kAnyGreen       = kSlot1Green  | kSlot2Green | kSlot15Green | kSlot16AttGreen,
        kAnyUV          = kSlot4UV     | kSlot5UV    | kSlot12UV    | kSlot13UV,
        kAnyBlue        = kSlot3Blue   | kSlot6Blue  | kSlot7Blue   | kSlot8Blue 
                        | kSlot9AttBlue| kSlot10Blue | kSlot11Blue  | kSlot14Blue, 
        kGreenAndBlue   = kAnyGreen & kAnyBlue,
        kBlueAndUV      = kAnyBlue  & kAnyUV,
        kGreenAndUV     = kAnyGreen & kAnyUV,
        kIFAEPulser     = kAnyGreen | kAnyBlue | kAnyUV,
        kAny            = kAnyGreen | kAnyBlue | kAnyUV | kCT1Pulser
      };

private:
    MTime   *fTime;            //! object to store the time in (ReadEvt)

    UInt_t   fDAQEvtNumber;    // Number of Event

    UInt_t   fNumTrigLvl1;     // Number of 1st level tiggers between 2 events
    UInt_t   fNumTrigLvl2;     // Number of 2nd level tiggers between 2 events
    UInt_t   fTrigPattern[2];  // Trigger configuration

    UShort_t fNumLoGainOn;     // Indicating if no pixel has a neglegible
                               // low gain signal (0), else it is the number
                               // of pixels with lo gain on

    //
    // Informations only needed to read the raw file correctly
    //
    UShort_t fTrigType;        //! Trigger Type of this event
    MArrayB *fPixLoGainOn;     //! Array which tell you which pixels have lo gain on

    Bool_t DecodeTime(UInt_t abstime[2], UShort_t ver) const;

    Int_t GetNumBytes() const;

public:
    MRawEvtHeader(const char *name=NULL, const char *title=NULL);
    ~MRawEvtHeader();

    void InitRead(MRawRunHeader *rh, MTime *t);

    void Clear(Option_t * = NULL);
    void Print(Option_t * = NULL) const;

    void FillHeader(UInt_t, Float_t=0);

    UShort_t   GetTrigType() const     { return fTrigType; }
    UInt_t     GetNumTrigLvl1() const  { return fNumTrigLvl1; }
    UInt_t     GetNumTrigLvl2() const  { return fNumTrigLvl2; }
    UInt_t     GetDAQEvtNumber() const { return fDAQEvtNumber; }
    
    UInt_t     GetTriggerID() const;
    UInt_t     GetCalibrationPattern() const;

    void       SetCalibrationPattern(UInt_t pat) { fTrigPattern[1] += (pat << 16); } // USE THIS FUNCTION WITH EXTREME CARE -- IT IS A WORKAROUND!

    UShort_t   GetPowerOfContLight() const;
    UInt_t     GetPulserSlotPattern() const;
    const MCalibrationCam::PulserColor_t GetPulserColor() const;
    Float_t    GetPulserStrength() const;
    
    CLColor_t  GetContLightColor() const;
    
    Int_t ReadEvt(istream& fin, UShort_t ver);
    void  SkipEvt(istream& fin, UShort_t ver);

    ClassDef(MRawEvtHeader, 1) // Parameter Conatiner for raw EVENT HEADER
}; 

#endif
