/*********************************/
/* Compute the hillas parameters */
/*********************************/

#include "TString.h"
#include "TArrayS.h"

#include "MParList.h"
#include "MTaskList.h"
#include "MPedestalCam.h"
#include "MBadPixelsCam.h"
#include "MBadPixelsTreat.h"
#include "MReadMarsFile.h"
#include "MGeomApply.h"
#include "MPedCalcPedRun.h"
#include "MEvtLoop.h"
#include "MGeomCamMagic.h"
#include "MExtractedSignalCam.h"
#include "MCalibrationChargeCam.h"
#include "MCalibrationQECam.h"
#include "MCalibrationQEPix.h"
#include "MHCalibrationChargeCam.h"
#include "MHCalibrationRelTimeCam.h"
#include "MExtractor.h"
#include "MExtractFixedWindow.h"
#include "MExtractSlidingWindow.h"
#include "MExtractSignal.h"
#include "MCalibrationChargeCalc.h"
#include "MFCosmics.h"
#include "MContinue.h"
#include "MLog.h"
#include "MCerPhotEvt.h"
#include "MPedPhotCam.h"
#include "MCalibrate.h"
#include "MPedPhotCalc.h"
#include "MHillas.h"
#include "MNewImagePar.h"
#include "MRawRunHeader.h"
#include "MSrcPosCam.h"
#include "MBlindPixelCalc.h"
#include "MImgCleanStd.h"
#include "MHillasSrcCalc.h"
#include "MHillasCalc.h"
#include "MArrivalTimeCam.h"
#include "MArrivalTimeCalc2.h"
#include "MIslands.h"
#include "MIslandCalc.h"
#include "MIslandClean.h"
#include "MWriteRootFile.h"
#include "MArgs.h"
#include "MRunIter.h"
#include "MJPedestal.h"
#include "MJCalibration.h"
#include "MHillasDisplay.h"
#include "MF.h"
#include "MContinue.h"

#include "TApplication.h"

#include <iostream>
#include <fstream>
#include <stdlib.h>

using namespace std;

Bool_t readDatacards(TString& filename);
void calib();

// initial and final time slices to be used in signal extraction
const Byte_t hifirst = 1;
const Byte_t hilast  = 14;
const Byte_t lofirst = 3;
const Byte_t lolast  = 14;

// declaration of variables read from datacards
TString  outname;
TString  idirname;
TString  filter;
TString  psfilename("makehillas.ps");
MRunIter caliter;
MRunIter pediter;
MRunIter datiter;
UInt_t   display   = 0;
ULong_t  nmaxevents= 999999999;
Short_t  calflag   = 1;
Float_t  lcore     = 3.0;
Float_t  ltail     = 1.5;
Int_t    islflag   = 0;
Float_t  lnew      = 40;
Int_t    kmethod   = 1;
Int_t    kalgorithm = 1;
Int_t    nfiles    = 0;

const TString defaultcard="makehillas.datacard";
/*************************************************************/
static void Usage()
{
  gLog <<endl;
  gLog << "Usage is:" << endl;
  gLog << "   calib [-h] [-?] <datacards>" << endl << endl;
  gLog << "     <datacards>: datacards file name (dafault input.datacards)" << endl;
  gLog << "     -?/-h: This help" << endl << endl;
}
/*************************************************************/
int main(int argc, char **argv)
{
  // create a TApplication to be able to 
  TApplication app("Application",0,0);

  // evaluate arguments
  MArgs arg(argc, argv);
  if (arg.HasOnly("-?") || arg.HasOnly("-h") || arg.HasOnly("--help"))
    {
      Usage();
      return -1;
    }

  TString datacard  = arg.GetArgumentStr(0);
  if(!datacard.Length())
    datacard = defaultcard;

  if(!readDatacards(datacard))
    {
      cout << "Error reading datacards. Stoping" << endl;
      return -1;
    }

  calib();
}

/*************************************************************/
void calib()
{
  // Set the general tasks/containers
  MExtractFixedWindow    extractor;
  extractor.SetRange(hifirst,hilast,lofirst,lolast);
 
  //  MExtractSlidingWindow    extractor;
  // extractor.SetRange(hifirst,hilast,lofirst,lolast);
  // extractor.SetWindowSize(2,2);
  
  MGeomCamMagic       geomcam;
  MGeomApply          geomapl;

  /************************************/
  /* FIRST LOOP: PEDESTAL COMPUTATION */
  /************************************/

  // If you want to exclude pixels from the beginning, read 
  // an ascii-file with the corr. pixel numbers (see MBadPixelsCam)  
  //badcam.AsciiRead("badpixels.dat");

  MJPedestal pedloop;
  pedloop.SetInput(&pediter);
  pedloop.SetExtractor(&extractor);
  //  pedloop.SetBadPixels(badcam);

  if (!pedloop.Process())
    return;

  /*****************************/
  /* SECOND LOOP: CALIBRATION  */
  /*****************************/        

  MJCalibration calloop;

  calloop.SetExtractor(&extractor);
  calloop.SetInput(&caliter);
  calloop.SetBadPixels(pedloop.GetBadPixels());
  if(calflag==2)
    calloop.SetUseBlindPixel();

  if(calflag>0)
    if (!calloop.Process(pedloop.GetPedestalCam()))
      return;

  Float_t meanCharge[577];
  Float_t meanSigma[577];
  Float_t meanFADC2Phe[577];
  Float_t meanFADC2Phe_error[577];
  Float_t meanFADCtoPh[577];
  Float_t prob[577];
  ofstream fout;

  fout.open(outname);

  for (Int_t i=0; i<577; i++)
    {
      meanCharge[i] = 0;
      MCalibrationChargePix calpix = (MCalibrationChargePix&)(calloop.GetCalibrationCam())[i];
      MCalibrationQEPix qepix = ( MCalibrationQEPix&)(calloop.GetQECam())[i];
      meanCharge[i] = calpix.GetMean();
      meanSigma[i] = calpix.GetSigma();
      meanFADC2Phe[i]=calpix.GetMeanConvFADC2Phe();
      meanFADC2Phe_error[i]=calpix.GetMeanConvFADC2PheErr();
      meanFADCtoPh[i]=calpix.GetMeanConvFADC2Phe()/qepix.GetQECascadesFFactor(0);
      prob[i]=calpix.GetProb();
      fout << i << '\t' << meanCharge[i] << '\t' << meanSigma[i]<< '\t' << meanFADC2Phe[i]<< '\t' << meanFADC2Phe_error[i]<< '\t' <<meanFADCtoPh[i]<< '\t' <<prob[i]<< '\t' <<(Int_t)calpix.IsHiGainSaturation()<< '\t' <<(Int_t)calpix.IsFFactorMethodValid()<<endl;
    }

  fout.close();

  /*****************************************************/
  /* THIRD LOOP: Q in fadc event by event CALIBRATION  */
  /*****************************************************/        

  MParList  plist4;
  MTaskList tlist4;
  plist4.AddToList(&tlist4);
  
  // containers 

  MCerPhotEvt         nphot;
  plist4.AddToList(&geomcam);
  plist4.AddToList(&pedloop.GetPedestalCam());
  plist4.AddToList(&nphot);
  
  //tasks
  MReadMarsFile read4("Events");
  static_cast<MRead&>(read4).AddFiles(caliter); 
  read4.DisableAutoScheme();
  
  MCalibrate::CalibrationMode_t calMode=MCalibrate::kNone;  

  MCalibrate      photcalc(calMode);

  tlist4.AddToList(&read4);
  tlist4.AddToList(&geomapl);
  tlist4.AddToList(&extractor);
  tlist4.AddToList(&photcalc);

  // Create and setup the eventloop
  MEvtLoop datloop;
  datloop.SetParList(&plist4);

  //  if (!datloop.Eventloop(nmaxevents))
  // return;
  outname+="_evt";

  datloop.PreProcess();

  fout.open(outname);
  while(tlist4.Process())
    {
      for(int i=0;i<577;i++)
	fout<<nphot[i].GetNumPhotons()<<" ";
      fout<<endl;
    }
  fout.close();
  datloop.PostProcess();
  return;

}
//-------------------------------------------------------------------------------

Bool_t readDatacards(TString& filename)
{
  ifstream ifun(filename.Data());
  if(!ifun)
    {
      cout << "File " << filename << " not found" << endl;
      return kFALSE;
    }

  TString word;
  
  while(ifun >> word)
    {
      // skip comments
      if(word[0]=='/' && word[1]=='/')
	{
	  while(ifun.get()!='\n'); // skip line
	  continue;
	}

      // input file directory
      if(strcmp(word.Data(),"IDIR")==0)
	{
	  if(idirname.Length())
	    cout << "readDataCards Warning: overriding input directory file name" << endl;
	  ifun >> idirname;
	}

      // pedestal runs
      if(strcmp(word.Data(),"PRUNS")==0)
	{
	  if(pediter.GetNumRuns())
	    cout << "readDataCards Warning: adding pedestal runs to the existing list" << endl;
	  ifun >> word;
	  pediter.AddRuns(word.Data(),idirname.Data());
	}

      // calibration runs
      if(strcmp(word.Data(),"CRUNS")==0)
	{
	  if(caliter.GetNumRuns())
	    cout << "readDataCards Warning: adding calibration runs to the existing list" << endl;
	  ifun >> word;
	  caliter.AddRuns(word.Data(),idirname.Data());
	}

      // output file name
      if(strcmp(word.Data(),"OUTFILE")==0)
	{
	  if(outname.Length())
	    cout << "readDataCards Warning: overriding output file name" << endl;
	  ifun >> outname;
	}

      // calibration flag
      if(strcmp(word.Data(),"CALFLAG")==0)
	ifun >> calflag;


    }

  pediter.Reset();
  caliter.Reset();
  datiter.Reset();
  TString pfile;

  // Dump read values
  cout << "************************************************" << endl;
  cout << "* Datacards read from file " << filename << endl;
  cout << "************************************************" << endl;
  cout << "Pedestal file (s): "  << endl;
  while(!(pfile=pediter.Next()).IsNull())
    cout << pfile << endl;
  cout << "Calibration file (s): "  << endl;
  while(!(pfile=caliter.Next()).IsNull())
    cout << pfile << endl;
  cout << "Output file name: " << outname << endl;
  cout << "Calibration: ";
  if(calflag==0)    
    cout << "Pixel area proportional intercalibration" << endl;
  else if(calflag==-1)    
    cout << "No calibration whatsoever" << endl;
  else if(calflag==1)
    cout << "Default calibration" << endl;
  else if(calflag==11)
    cout << "Default calibration + bad pixels interpolation" << endl;
  
  if(!pediter.GetNumEntries())
    {
      cout << "No pedestal file name specified" << endl;
      return kFALSE;
    }
  if(!caliter.GetNumEntries() && calflag>0)
    {
      cout << "No calibration file name specified" << endl;
      return kFALSE;
    }
  if(!outname.Length())
    {
      cout << "No output file name specified" << endl;
      return kFALSE;
    }


  return kTRUE;
}

