#ifndef MARS_MagicTriggerDisplay
#define MARS_MagicTriggerDisplay

#ifndef MARS_MAGIC
#include "MAGIC.h"
#endif
#ifndef ROOT_TClonesArray
#include <TClonesArray.h>
#endif
#ifndef ROOT_RQ_OBJECT
#include <RQ_OBJECT.h>
#endif

class TText;
class TMarker;
class TVirtualPad;

class MGeomCam;
class MHexagon;

class TGMainFrame;
class TRootEmbeddedCanvas;
class TGWindow;
class TGTextEntry;
class MagicTriggerButton;
class MMcTriggerLvl2;

class MagicTriggerDisplay : public TObject
{
private:
    static const Int_t kMinCell = 1;
    static const Int_t kMaxCell = 19;
    static const Int_t kMinLUT = 1;
    static const Int_t kMaxLUT = 3;

    Int_t cn;
    Int_t ln;

    TGMainFrame          *fMain;
    TRootEmbeddedCanvas  *fEcanvas;
    TGTextEntry          *fCellEntry;
    TGTextEntry          *fLUTEntry;
    MagicTriggerButton   *cellBackward;
    MMcTriggerLvl2       *fTrig;
    const Int_t *fPixelsInLUT;
    const Int_t *fPixelsInCell;

    MGeomCam      *fGeomCam;       // pointer to camera geometry

    UInt_t         fNumPixels;     // number of pixels in the present geometry
    Float_t        fRange;         // the range in millimeters of the present geometry

    TClonesArray  *fPixels;        // array of all hexagons
    TClonesArray  *fText;          // array of all texts
    TClonesArray  *fFlags;         // array of all texts

    TText         *fDone;          // TText showing the 'Game over'
    TText         *fUsrTxt[6];     // TText showing the numbers of pixels and bombs

    UInt_t         fW;             // Width of canvas
    UInt_t         fH;             // Height of canvas
    TVirtualPad   *fDrawingPad;    // pad in which we are drawing
    Bool_t         fIsAllocated;

    Int_t          fNumUsers;
    Int_t          fNumUser;
    Int_t          fUsrPts[6];

    enum
    {
        kEmpty     = 50,
        kIsVisible = BIT(16),
        kHasBomb   = BIT(17),
        kHasFlag   = BIT(18),
        kUserBits  = 0x7fc000 // 14-23 are allowed
    };

    MHexagon &operator[](int i) { return *((MHexagon*)fPixels->At(i)); }

    TText   *GetText(Int_t i) { return (TText*)fText->At(i); }
    TMarker *GetFlag(Int_t i) { return (TMarker*)fFlags->At(i); }

    void Free();
    void SetNewCamera(MGeomCam *);
    void DrawHexagons();
    void Paint(Option_t *option="");
    void Draw(Option_t *opt = "");
public:
    MagicTriggerDisplay(const TGWindow *p, UInt_t w = 500, UInt_t h = 500);

    void  Update(const Int_t butt = 0, const Int_t entry = 0);

    ClassDef(MagicTriggerDisplay, 0) // Magic Camera Games: Reversi
};

#endif
