#ifndef MARS_MJCalibrateSignalFromOutside
#define MARS_MJCalibrateSignalFromOutside

#ifndef MARS_MJob
#include "MJob.h"
#endif
#ifndef MARS_MBadPixelsCam
#include "MBadPixelsCam.h"
#endif

class TEnv;
class TList;

class MTask;
class MParList;
class MGeomCam;
class MSequence;
class MExtractor;
class MPedestalCam;
class MBadPixelsCam;
class MRunIter;
class MCalibrationChargeCam;
class MCalibrationQECam;
class MCalibrationRelTimeCam;

class MJCalibrateSignalFromOutside : public MJob
{
private:
    Bool_t fIsDataCheck;
    TString fGeometry;                // Class name geometry
    
    MRunIter       *fRuns;            // Data files
    MExtractor     *fExtractor;       // Signal extractor 

    MBadPixelsCam  fBadPixels;        // Bad Pixels cam, can be set from previous runs  
    
    enum  Storage_t                    // Possible devices for calibration
      {
        kNoStorage,
        kHistsStorage
      };                              // Possible flags for the storage of results
    
    Byte_t fStorage;                  // Bit-field for chosen storage type

    Bool_t IsNoStorage    () const { return TESTBIT(fStorage,kNoStorage);    }
    Bool_t IsHistsStorage () const { return TESTBIT(fStorage,kHistsStorage); }

    Bool_t WriteResult();

    Bool_t IsDataCheck() const { return fIsDataCheck; }
    void SetDataCheck(Bool_t b) { fIsDataCheck = b; }

public:
    MJCalibrateSignalFromOutside(const char *name=NULL, const char *title=NULL);

    //    const char* GetOutputFile() const;

    void SetBadPixels  ( const MBadPixelsCam &bad)     { bad.Copy(fBadPixels); }
    void SetExtractor  ( MExtractor* ext)              { fExtractor = ext;     }
    void SetInput     ( MRunIter *iter)               { fRuns = iter;         }

    // Camera Geomtry
    void SetGeometry(const char *geom) { fGeometry = geom; }
  
    // Storage
    void SetNoStorage    ( const Bool_t b=kTRUE ) { b ? SETBIT(fStorage,kNoStorage)    : CLRBIT(fStorage,kNoStorage); }
    void SetHistsStorage ( const Bool_t b=kTRUE ) { b ? SETBIT(fStorage,kHistsStorage) : CLRBIT(fStorage,kHistsStorage); }
    
    Bool_t ProcessFile(MPedestalCam &camab, MPedestalCam &cam, MCalibrationChargeCam &chargecam,
                       MCalibrationQECam &qecam, MCalibrationRelTimeCam &relcam, Byte_t filetype=2);

    ClassDef(MJCalibrateSignalFromOutside, 0) // Tool to create a pedestal file (MPedestalCam)
};

#endif
