#ifndef MARS_MMcEnergyEst
#define MARS_MMcEnergyEst

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

#include "MFilter.h"

class MMcEnergyEst : public MParContainer
{
private:

  TString fInFile, fOutFile;
  TString fHillasName;
  TString fHillasSrcName;
  Int_t   fNevents;

  MFilter *fEventFilter; //!

  TArrayD fA;
  TArrayD fB;

public:
  MMcEnergyEst(const char *name=NULL, const char *title=NULL);

  void SetInFile(const TString &name)         {fInFile = name;}
  void SetOutFile(const TString &name)        {fOutFile = name;}
  void SetHillasName(const TString &name)     {fHillasName = name;}
  void SetHillasSrcName(const TString &name)  {fHillasSrcName = name;}
  void SetEventFilter(MFilter *filter)        {fEventFilter = filter;}
  void SetNevents(Int_t n)                    {fNevents = n;}

  TString GetInFile()         const {return fInFile;}
  TString GetOutFile()        const {return fOutFile;}
  TString GetHillasName()     const {return fHillasName;}
  TString GetHillasSrcName()  const {return fHillasSrcName;}
  Int_t   GetNevents()        const {return fNevents;}

  Int_t   GetNumCoeffA()      const {return fA.GetSize(); }
  Int_t   GetNumCoeffB()      const {return fB.GetSize(); }

  Double_t GetCoeff(Int_t i) { return i<fA.GetSize()? fA[i] : fB[i-fA.GetSize()]; }

  Bool_t SetCoeff(TArrayD &coeff);

  void FindParams();
  void Print(Option_t *o="") const;

  ClassDef(MMcEnergyEst, 1) // Class for optimization of Energy estimator
};

#endif

