#ifndef MARS_MReportCC
#define MARS_MReportCC

#ifndef MARS_MReport
#include "MReport.h"
#endif

class MReportCC : public MReport
{
private:
    Float_t fHumidity;       // [%]
    Float_t fTemperature;    // [deg] celsius
    Float_t fWindSpeed;      // [km/h]
    Float_t fSolarRadiation; // [W/m^2] IR-Radiation

    Int_t InterpreteBody(TString &str, Int_t ver);

public:
    MReportCC();

    Float_t GetHumidity() const       { return fHumidity; }
    Float_t GetTemperature() const    { return fTemperature; }
    Float_t GetWindSpeed() const      { return fWindSpeed; }
    Float_t GetSolarRadiation() const { return fSolarRadiation; }

    ClassDef(MReportCC, 1) // Class for CC-REPORT information
};

#endif
