#ifndef MARS_MCalibCalcFromPast
#define MARS_MCalibCalcFromPast

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MParList;
class MGeomCam;
class MRawEvtHeader;
class MRawRunHeader;
class MPedCalcFromLoGain;
class MCalibrationChargeCalc;
class MCalibrationRelTimeCalc;
class MCalibrationIntensityChargeCam;
class MCalibrationIntensityBlindCam;
class MCalibrationIntensityQECam;
class MCalibrationIntensityRelTimeCam;
class MCalibrationIntensityHiLoCam;
class MBadPixelsIntensityCam;
class MCalibCalcFromPast : public MTask
{
private:

  static const UInt_t fgNumEventsDump;                //! Default for fNumEventsDump
  
  MRawEvtHeader                   *fHeader;          //!
  MRawRunHeader                   *fRunHeader;       //!
  MGeomCam                        *fGeom;            //!
  MParList                        *fParList;         //!
  MCalibrationIntensityChargeCam  *fIntensCharge;    //!
  MCalibrationIntensityBlindCam   *fIntensBlind;     //!  
  MCalibrationIntensityQECam      *fIntensQE;        //!
  MCalibrationIntensityRelTimeCam *fIntensRelTime;   //!
  MCalibrationIntensityHiLoCam    *fIntensHiLo;      //!
  MBadPixelsIntensityCam          *fIntensBad;       //!
  
  MCalibrationChargeCalc          *fChargeCalc;      //!
  MCalibrationRelTimeCalc         *fRelTimeCalc;     //!
                                                     
  UInt_t fNumEventsDump;       // Number of event after which the MCalibrationCams gets updated
  UInt_t fPattern;             // Calibration bit pattern from digital modules
  
  Int_t  PreProcess(MParList *pList);
  Int_t  Process();
  
  Bool_t ReInitialize();
  Bool_t Finalize(const char* name);
  const char* GetNamePattern();
  
public:

    MCalibCalcFromPast(const char *name=NULL, const char *title=NULL);
    ~MCalibCalcFromPast() {}

    UInt_t GetNumEventsDump() const   {  return fNumEventsDump;   }

    void SetNumEventsDump( const UInt_t i=fgNumEventsDump )   { fNumEventsDump = i; }

    ClassDef(MCalibCalcFromPast, 1) // Task to steer the processing of interlace calibration events
};
    
#endif

