#ifndef MARS_MHCalibrationHiLoCam
#define MARS_MHCalibrationHiLoCam

#ifndef MARS_MHCalibrationCam
#include "MHCalibrationCam.h"
#endif

#ifndef MARS_MArrayI
#include "MArrayI.h"
#endif

#ifndef MARS_MArrayD
#include "MArrayD.h"
#endif

class TH1F;

class MGeomCam;
class MRawEvtData;
class MHCalibrationHiLoCam : public MHCalibrationCam
{

private:

  static const Int_t   fgNbins;                      //! Default number of bins        (now set to: 900   )
  static const Axis_t  fgFirst;                      //! Default lower histogram limit (now set to: -13.5 )
  static const Axis_t  fgLast;                       //! Default upper histogram limit (now set to:  13.5 )
  static const Float_t fgProbLimit;                  //! The default for fProbLimit    (now set to: 0.0)  
  
  static const TString gsHistName;                   //! Default Histogram names
  static const TString gsHistTitle;                  //! Default Histogram titles
  static const TString gsHistXTitle;                 //! Default Histogram x-axis titles
  static const TString gsHistYTitle;                 //! Default Histogram y-axis titles

  static const Byte_t  fgLowerLim;                   //! Default for fLowerLimt        (now set to: 200)
  static const Byte_t  fgUpperLim;                   //! Default for fUpperLimt        (now set to: 252)

  Byte_t fLowerLim;                                 //  Lower allowed FADC value limit for max. slicey
  Byte_t fUpperLim;                                 //  Upper allowed FADC value limit for max. slicey
  
  MArrayD fSumarea  ;                               //
  MArrayD fSumsector;                               //
  MArrayI fNumarea  ;                               //
  MArrayI fNumsector;                               //

  MRawEvtData                       *fRawEvt;       //!  Raw event data 

  Bool_t SetupHists(const MParList *pList);  
  Bool_t ReInitHists(MParList *pList);
  Bool_t FillHists(const MParContainer *par, const Stat_t w=1);
  Bool_t FinalizeHists();
  void   FinalizeBadPixels();

  void   CheckOverflow( MHCalibrationPix &pix);
  
public:

  MHCalibrationHiLoCam(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationHiLoCam() {}

  // Clone
  TObject *Clone(const char *name="") const;

  Byte_t GetLowerLim() const { return fLowerLim; }
  Byte_t GetUpperLim() const { return fUpperLim; }    

  void  SetLowerLim( const UInt_t i=fgLowerLim) { fLowerLim = i; }
  void  SetUpperLim( const UInt_t i=fgUpperLim) { fUpperLim = i; }

  Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void DrawPixelContent(Int_t idx) const;

  ClassDef(MHCalibrationHiLoCam, 1)	// Histogram class for High Gain vs. Low Gain Calibration
};

#endif
