#ifndef MARS_MDispParameters
#define MARS_MDispParameters

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

class MDispParameters : public MParContainer
{
private:

    TArrayD fParameters;      // Disp parameters
    TArrayD fStepsizes;       //! step sizes of Disp parameters


public:

    MDispParameters(const char *name=NULL, const char *title=NULL);

    void InitParameters();

    Bool_t SetParameters(const TArrayD &d);
    Bool_t SetStepsizes(const TArrayD &d);

    void SetVariables(const TArrayD &d)    { SetParameters(d); }
 
    TArrayD &GetParameters() { return fParameters; }
    TArrayD &GetStepsizes()  { return fStepsizes;  }

    ClassDef(MDispParameters, 1) // Container for the Disp parameters
};

#endif



