#ifndef MARS_MCalibrationPattern
#define MARS_MCalibrationPattern

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef MARS_MCalibrationCam
#include "MCalibrationCam.h"
#endif

class MCalibrationPattern : public MParContainer
{
    friend class MCalibrationPatternDecode;

public:

    enum CLColor_t 
      {
        kCLUV       = BIT(0),
        kCLGreen    = BIT(1),
        kCLAmber    = BIT(2),
        kCLRed      = BIT(3),
        kCLRedAmber   = kCLRed & kCLAmber,
        kCLRedGreen   = kCLRed & kCLGreen,
        kCLRedUV      = kCLRed & kCLUV   ,
        kCLAmberGreen = kCLAmber & kCLGreen,
        kCLAmberUV    = kCLAmber & kCLUV   ,
        kCLGreenUV    = kCLGreen & kCLUV   ,
        kCLRedAmberGreen = kCLRedAmber & kCLGreen,
        kCLRedGreenUV    = kCLRedGreen & kCLUV,
        kCLAmberGreenUV  = kCLAmberGreen & kCLUV,
        kCLAll           = kCLRedAmberGreen & kCLUV,
	kCLNone    = BIT(4)
      };
    
    enum PulserColorCode_t 
      {
        kSlot1Green     = BIT(0),
        kSlot2Green     = BIT(1),
        kSlot3Blue      = BIT(2),
        kSlot4UV        = BIT(3),
        kSlot5UV        = BIT(4),
        kSlot6Blue      = BIT(5),
        kSlot7Blue      = BIT(6),
        kSlot8Blue      = BIT(7),
        kSlot9AttBlue   = BIT(8),
        kSlot10Blue     = BIT(9),
        kSlot11Blue     = BIT(10),
        kSlot12UV       = BIT(11),
        kSlot13UV       = BIT(12),
        kSlot14Blue     = BIT(13),
        kSlot15Green    = BIT(14),
        kSlot16AttGreen = BIT(15),
        kCT1Pulser      = BIT(16),
        kAnyGreen       = kSlot1Green  | kSlot2Green | kSlot15Green | kSlot16AttGreen,
        kAnyUV          = kSlot4UV     | kSlot5UV    | kSlot12UV    | kSlot13UV,
        kAnyBlue        = kSlot3Blue   | kSlot6Blue  | kSlot7Blue   | kSlot8Blue 
                        | kSlot9AttBlue| kSlot10Blue | kSlot11Blue  | kSlot14Blue, 
        kGreenAndBlue   = kAnyGreen & kAnyBlue,
        kBlueAndUV      = kAnyBlue  & kAnyUV,
        kGreenAndUV     = kAnyGreen & kAnyUV,
        kIFAEPulser     = kAnyGreen | kAnyBlue | kAnyUV,
        kAny            = kAnyGreen | kAnyBlue | kAnyUV | kCT1Pulser
      };

private:

    UShort_t  fCLStrength;     // Continuous light strenth  
    CLColor_t fCLColor;        // Color (combinations) of the continuous light
    Float_t   fPulserStrength; // Strength of the pulsed light (in nr. of equiv. LEDs)
    
    MCalibrationCam::PulserColor_t fPulserColor; // Colour of the pulsed light

public:

    MCalibrationPattern(const char *name=0, const char *title=0);

    void Reset() { fCLStrength=0; fCLColor=kCLNone; fPulserColor=MCalibrationCam::kNONE; fPulserStrength=0.; }

    UShort_t   GetCLStrength()     const { return fCLStrength; }
    CLColor_t  GetCLColor()        const { return fCLColor; }
    Float_t    GetPulserStrength() const { return fPulserStrength; }

    const MCalibrationCam::PulserColor_t GetPulserColor() const { return fPulserColor; }

    void SetPulserColor   ( const MCalibrationCam::PulserColor_t col) { fPulserColor = col; }
    void SetPulserStrength( const Float_t strength ) { fPulserStrength = strength; }

    ClassDef(MCalibrationPattern, 1) // Container storing the decoded calibration pattern
};

#endif
