/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cherenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!   Author(s): Daniel Mazin, 05/2004 <mailto:mazin@imppmu.mpg.de>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

// Daniel Mazin 26.09.2004  mazin@mppmu.mpg.de
//**********************************************************
// this macro :
// 1)  take Hillas Parameters and produce a sky plot
//**********************************************************

gROOT->Reset();

//************************************************************************
void MySkyPlot(const char *onfile) 
{

    TString fileON  = onfile;

    // name of input root file
    TString filenamein(fileON);


    //  set up the task list:
    //-----------------------------------------------------------
    MTaskList tlist;
    MParList plist;


    TString XPosMaxString ("MSrcPosCam.fX<0.1");
    MContinue XPosMaxCut(XPosMaxString);
    XPosMaxCut.SetInverted();

    TString XPosMinString ("MSrcPosCam.fX>-0.1");
    MContinue XPosMinCut(XPosMinString);
    XPosMinCut.SetInverted();

    TString YPosMaxString ("MSrcPosCam.fY<0.1");
    MContinue YPosMaxCut(YPosMaxString);
    YPosMaxCut.SetInverted();

    TString YPosMinString ("MSrcPosCam.fY>-0.1");
    MContinue YPosMinCut(YPosMinString);
    YPosMinCut.SetInverted();



    MSkyPlot skyplot; 
    skyplot.SetMinDist(0.2);
    //skyplot.ReadCuts("/local/supercuts/OptSCParametersONOFFThetaRange0_1570mRad.root");
    //skyplot.ReadCuts("/remote/home/pc1/operator/mazin/supercuts/2004_09_13/Zd20_60all/Cuts.root");
    //skyplot.ReadCuts("/local/supercuts/2004_09_13/OptDynCuts2000CrabNebula.root");
    //skyplot.ReadCuts("/remote/home/pc17/operator/OnlineA/supercuts/OptDynCuts2000CrabNebula.root");
    //skyplot.ReadCuts("/home/pcmagic04/pratik/crab_analysis/sept2k4/gt2000/RootFileDynCuts_crabsept_GREEN_15o30deg.root");
    skyplot.ReadCuts("/home/pcmagic04/pratik/crab_analysis/sept2k4/gt2000/RootFileDynCuts_20to30deg_alldata.root");
    skyplot.SetSkyPlot(-1.,1.,-1.,1.,0.05);
    skyplot.SetSizeMin(2000.);
    skyplot.SetSizeMax(1e6);
    skyplot.SetOutputAlphaName("Crab21_UV.root");
    skyplot.SetOutputSkyName("Crab21_UV.root");


    MObservatory mobs;

    plist.AddToList(&mobs);

    // geometry is needed in  MHHillas... classes 
    const MGeomCam *fGeom = 
             (MGeomCam*)plist->FindCreateObj("MGeomCamMagic", "MGeomCam");

    //-------------------------------------------
    // create the tasks which should be executed 
    //

    MReadReports read;
    read.AddTree("Drive");
//    read.AddTree("CC");
//    read.AddTree("Events");
    read.AddTree("Events","MTime.",kTRUE);
 
    read.AddFile(filenamein);
 
    read.AddToBranchList("MReportDrive.*");
//    read.AddToBranchList("MRawEvtHeader.*");


    //MReadMarsFile read("Events", filenamein);
    //MReadMarsFile read(filenamein);
    //read.DisableAutoScheme();

    MGeomApply        apply;

    

    //*****************************
    // entries in MParList
    
    plist.AddToList(&tlist);

//    pliston.AddToList(&source);

    //*****************************
    // entries in MTaskList
    

    tlist.AddToList(&read);
    tlist.AddToList(&apply);

    tlist.AddToList(&XPosMaxCut);
    tlist.AddToList(&XPosMinCut);

    tlist.AddToList(&YPosMaxCut);
    tlist.AddToList(&YPosMinCut);

    tlist.AddToList(&skyplot);

    //*****************************

    //-------------------------------------------
    // Execute event loop
    //
    MProgressBar bar;
    MEvtLoop evtloop;
    evtloop.SetParList(&plist);
    evtloop.SetProgressBar(&bar);
/*
    Int_t maxevents = -1;
    //Int_t maxevents = 1000;
    if ( !evtloop.Eventloop(maxevents) )
        return;
*/
    if (!evtloop.PreProcess())
            return;

    Int_t counter=0;
    while(tlist.Process())
    {
      counter++;
      if(counter%10000 == 0) cout << "events = " << counter << endl;
//     MReportDrive * mrepdrive = (MReportDrive *)pliston.FindObject("MReportDrive");
//     cout << "Ra " << mrepdrive->GetRa() << ", Dec " << mrepdrive->GetDec() << endl;
//     MHillasSrc * mhs = (MHillasSrc*)pliston.FindObject("MHillasSrc");
//     mhs->Print();
    }

    evtloop.PostProcess(); 
 
    tlist.PrintStatistics(0, kTRUE);

}



