/*############################################################################
  #
  #   Input: 
  #   - A 3D hist of Alpha vs Energy vs Theta
  #   - A 2D hist of DiffTime vs Time
  #   - A 2D with Effective Collection Area 
  # 
  #  Then calculate:
  #   - Effecive on Time
  #   - Nex for the Alpha plot foreach bin (energy,theta)
  #
  #
  #  Fixed a bug: the loop for extracing the signal started in bin=0 instead in
  #               bin 1. 
  # 
  #  Fixed a bug: the above change introduced a extremely important bug, since
  #   the loop started from 1 but we have in the arrays:
  #         signal[i] = fNex;
  #	    errorsignal[i] = fdNex;
  #  so the signal[0] was actually the signal for the last bin. For that we 
  #  had a very low point in the first bin and all the spectrum was displaced.
  #  Now it is fixed with:
  #           signal[i-1] = fNex;
  #	    errorsignal[i-1] = fdNex;
  #
  #                                                authors: Marcos Lopez
  #                                                         Rober Wagner
  #                                                   email: marcos@gae.ucm.es
  #                                                   date:  31-11-2004
  #                                           last revision: 31-11-2004  
  ###########################################################################*/

void Flux6() 
{

    //TString datafile = "flux/Alpha10_H3.New.Resized.root";
    //TString datafile = "flux/Alpha10_HadCut_Variable.Resized.root";
    TString datafile = "flux/Alpha10_HadCut_Variable.SizeAbove250.Resized.root";
    //TString datafile = "flux/Alpha_E_50_2000_10bins_HadCut_Variable.SizeAbove250.Resized.root";


    //TString areafile = "flux/area_HadCut_03_and_AlphaCut_20.Resized.root";
    //TString areafile = "../mcdata/collarea.root";
    //TString areafile = "area_HadCut03_and_AlphaCut20.root";
    //TString areafile = "area_HacCut_Variable_and_AlphaCut_20.Resized.root";
    //TString areafile = "area_HacCut_Variable.Resized.root";
    TString areafile = "flux/area_HadCut_Variable.SizeAbove250.Resized.root";

    // ------------------------------------------------------------------------
    // 
    //  Load histograms from file
    //
    TFile* file = new TFile(datafile);

    //
    // Read Hist of Alpha Vs. Energy and Theta
    //
    MHAlphaEnergyTheta hAlpha;
    hAlpha.Read("MHAlphaEnergyTheta");
    hAlpha.DrawClone();

    //
    // Read Hist of EffectiveTime vs. Theta and Time
    //
    MHEffectiveOnTime hEffTime;
    hEffTime.Read("MHEffectiveOnTime");
    hEffTime.DrawClone();

    //
    // Read CollectionArea
    //
    TFile* file3 = new TFile(areafile);
    MHMcCollectionArea area;
    area.Read("MHMcCollectionArea");
    area.DrawClone();


    // ----------------------------------------------------------------------- 
    //
    // Calculate # Excess events vs. Energy and Theta
    //
    MHExcessEnergyTheta *hex = new MHExcessEnergyTheta;
    hex->Calc(&hAlpha);
    hex->Draw();

    //
    // Calculate diferential Flux vs. Enregy and Theta
    //
    MHFlux* hFlux = new MHFlux;
    hFlux->Calc(hex, &area, &hEffTime);
    hFlux->Draw();



    
    //
    // Write flux into root file
    //
    TFile outfile("flux/Flux.root","RECREATE");
    hFlux->Write();
    outfile.Close();

}

